/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.filesys.util;

import java.io.PrintStream;

public final class HexDump {
    public static final void Dump(byte[] byt) {
        HexDump.Dump(byt, byt.length, 0, System.out);
    }

    public static final void Dump(byte[] byt, int len, int offset) {
        HexDump.Dump(byt, len, offset, System.out);
    }

    public static final void Dump(byte[] byt, int len, int offset, PrintStream stream) {
        StringBuilder ascBuf = new StringBuilder();
        StringBuilder hexBuf = new StringBuilder();
        int doff = offset;
        String posStr = null;
        for (int dlen = 0; dlen < len; dlen += 16) {
            ascBuf.setLength(0);
            hexBuf.setLength(0);
            posStr = HexDump.generatePositionString(doff);
            doff = HexDump.generateLine(byt, doff, ascBuf, hexBuf);
            stream.print(posStr);
            stream.print(hexBuf.toString());
            stream.println(ascBuf.toString());
        }
    }

    public static final String hexString(String str) {
        if (str != null) {
            return HexDump.hexString(str.getBytes());
        }
        return "";
    }

    public static final String hexString(String str, String gap) {
        if (str != null) {
            return HexDump.hexString(str.getBytes(), gap);
        }
        return "";
    }

    public static final String hexString(byte[] buf) {
        return HexDump.hexString(buf, 0, buf.length, null);
    }

    public static final String hexString(byte[] buf, String gap) {
        return HexDump.hexString(buf, 0, buf.length, gap);
    }

    public static final String hexString(byte[] buf, int off, int len, String gap) {
        if (buf == null) {
            return "";
        }
        int buflen = (buf.length - off) * 2;
        if (gap != null) {
            buflen += buf.length * gap.length();
        }
        StringBuilder hex = new StringBuilder(buflen);
        for (int i = 0; i < len; ++i) {
            int curbyt = buf[off + i] & 0xFF;
            hex.append(Integer.toHexString((curbyt & 0xF0) >> 4));
            hex.append(Integer.toHexString(curbyt & 0xF));
            if (gap == null || i >= len - 1) continue;
            hex.append(gap);
        }
        return hex.toString();
    }

    private static final String generatePositionString(int off) {
        StringBuilder posStr = new StringBuilder("" + off + " - ");
        while (posStr.length() < 8) {
            posStr.insert(0, " ");
        }
        return posStr.toString();
    }

    private static final int generateLine(byte[] byt, int off, StringBuilder ascBuf, StringBuilder hexBuf) {
        int dumplen = byt.length - off;
        if (dumplen > 16) {
            dumplen = 16;
        }
        for (int i = 0; i < dumplen; ++i) {
            int curbyt = byt[off++] & 0xFF;
            hexBuf.append(Integer.toHexString((curbyt & 0xF0) >> 4));
            hexBuf.append(Integer.toHexString(curbyt & 0xF));
            hexBuf.append(" ");
            if (Character.isLetterOrDigit((char)curbyt) || Character.getType((char)curbyt) != 15) {
                ascBuf.append((char)curbyt);
                continue;
            }
            ascBuf.append(".");
        }
        hexBuf.append("  - ");
        return off;
    }
}

