/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jcr.dictionary;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.alfresco.jcr.dictionary.NodeTypeImpl;
import org.alfresco.jcr.dictionary.VersionableMixin;
import org.alfresco.jcr.session.SessionImpl;
import org.alfresco.model.ContentModel;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;

public class ClassMap {
    private static Map<QName, QName> JCRToAlfresco = new HashMap<QName, QName>();
    private static Map<QName, QName> AlfrescoToJCR;
    private static Map<QName, AddMixin> addMixin;
    private static Map<QName, RemoveMixin> removeMixin;
    private static DefaultMixin defaultMixin;

    public static QName convertTypeToClass(QName jcrType) {
        return JCRToAlfresco.get(jcrType);
    }

    public static QName convertClassToType(QName alfrescoClass) {
        return JCRToAlfresco.get(alfrescoClass);
    }

    public static AddMixin getAddMixin(QName alfrescoClass) {
        AddMixin mixin = addMixin.get(alfrescoClass);
        return mixin == null ? defaultMixin : mixin;
    }

    public static RemoveMixin getRemoveMixin(QName alfrescoClass) {
        RemoveMixin mixin = removeMixin.get(alfrescoClass);
        return mixin == null ? defaultMixin : mixin;
    }

    static {
        JCRToAlfresco.put(NodeTypeImpl.MIX_REFERENCEABLE, ContentModel.ASPECT_REFERENCEABLE);
        JCRToAlfresco.put(NodeTypeImpl.MIX_LOCKABLE, ContentModel.ASPECT_LOCKABLE);
        JCRToAlfresco.put(NodeTypeImpl.MIX_VERSIONABLE, ContentModel.ASPECT_VERSIONABLE);
        AlfrescoToJCR = new HashMap<QName, QName>();
        AlfrescoToJCR.put(ContentModel.ASPECT_REFERENCEABLE, NodeTypeImpl.MIX_REFERENCEABLE);
        AlfrescoToJCR.put(ContentModel.ASPECT_LOCKABLE, NodeTypeImpl.MIX_LOCKABLE);
        AlfrescoToJCR.put(ContentModel.ASPECT_VERSIONABLE, NodeTypeImpl.MIX_VERSIONABLE);
        addMixin = new HashMap<QName, AddMixin>();
        addMixin.put(ContentModel.ASPECT_VERSIONABLE, new VersionableMixin());
        removeMixin = new HashMap<QName, RemoveMixin>();
        removeMixin.put(ContentModel.ASPECT_VERSIONABLE, new VersionableMixin());
        defaultMixin = new DefaultMixin();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DefaultMixin
    implements AddMixin,
    RemoveMixin {
        private DefaultMixin() {
        }

        @Override
        public Map<QName, Serializable> preAddMixin(SessionImpl session, NodeRef nodeRef) {
            return null;
        }

        @Override
        public void postAddMixin(SessionImpl session, NodeRef nodeRef) {
        }

        @Override
        public void preRemoveMixin(SessionImpl session, NodeRef nodeRef) {
        }

        @Override
        public void postRemoveMixin(SessionImpl session, NodeRef nodeRef) {
        }
    }

    public static interface RemoveMixin {
        public void preRemoveMixin(SessionImpl var1, NodeRef var2);

        public void postRemoveMixin(SessionImpl var1, NodeRef var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface AddMixin {
        public Map<QName, Serializable> preAddMixin(SessionImpl var1, NodeRef var2);

        public void postAddMixin(SessionImpl var1, NodeRef var2);
    }
}

