/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jcr.dictionary;

import java.util.HashMap;
import java.util.Map;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.namespace.QName;

public class DataTypeMap {
    private static Map<QName, Integer> dataTypeToPropertyType = new HashMap<QName, Integer>();
    private static Map<Integer, QName> propertyTypeToDataType;

    public static int convertDataTypeToPropertyType(QName datatype) {
        Integer propertyType = dataTypeToPropertyType.get(datatype);
        if (propertyType == null) {
            throw new AlfrescoRuntimeException("Cannot map Alfresco data type " + datatype + " to JCR property type.");
        }
        return propertyType;
    }

    public static QName convertPropertyTypeToDataType(int propertyType) {
        QName type = propertyTypeToDataType.get(propertyType);
        if (type == null) {
            throw new AlfrescoRuntimeException("Cannot map JCR property type " + propertyType + " to Alfresco data type.");
        }
        return type;
    }

    static {
        dataTypeToPropertyType.put(DataTypeDefinition.TEXT, 1);
        dataTypeToPropertyType.put(DataTypeDefinition.CONTENT, 2);
        dataTypeToPropertyType.put(DataTypeDefinition.INT, 3);
        dataTypeToPropertyType.put(DataTypeDefinition.LONG, 3);
        dataTypeToPropertyType.put(DataTypeDefinition.FLOAT, 4);
        dataTypeToPropertyType.put(DataTypeDefinition.DOUBLE, 4);
        dataTypeToPropertyType.put(DataTypeDefinition.DATE, 5);
        dataTypeToPropertyType.put(DataTypeDefinition.DATETIME, 5);
        dataTypeToPropertyType.put(DataTypeDefinition.BOOLEAN, 6);
        dataTypeToPropertyType.put(DataTypeDefinition.QNAME, 7);
        dataTypeToPropertyType.put(DataTypeDefinition.CATEGORY, 1);
        dataTypeToPropertyType.put(DataTypeDefinition.NODE_REF, 9);
        dataTypeToPropertyType.put(DataTypeDefinition.PATH, 8);
        dataTypeToPropertyType.put(DataTypeDefinition.ANY, 0);
        propertyTypeToDataType = new HashMap<Integer, QName>();
        propertyTypeToDataType.put(1, DataTypeDefinition.TEXT);
        propertyTypeToDataType.put(2, DataTypeDefinition.CONTENT);
        propertyTypeToDataType.put(3, DataTypeDefinition.LONG);
        propertyTypeToDataType.put(4, DataTypeDefinition.DOUBLE);
        propertyTypeToDataType.put(5, DataTypeDefinition.DATETIME);
        propertyTypeToDataType.put(6, DataTypeDefinition.BOOLEAN);
        propertyTypeToDataType.put(7, DataTypeDefinition.QNAME);
        propertyTypeToDataType.put(9, DataTypeDefinition.NODE_REF);
        propertyTypeToDataType.put(8, DataTypeDefinition.PATH);
        propertyTypeToDataType.put(0, DataTypeDefinition.ANY);
    }
}

