/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jcr.dictionary;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.alfresco.jcr.dictionary.JCRNamespace;
import org.alfresco.service.namespace.NamespaceException;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JCRNamespacePrefixResolver
implements NamespaceService {
    private NamespacePrefixResolver delegate;
    private Map<String, String> prefixes = new HashMap<String, String>();
    private Map<String, String> uris = new HashMap<String, String>();

    public JCRNamespacePrefixResolver(NamespacePrefixResolver delegate) {
        this.delegate = delegate;
    }

    @Override
    public Collection<String> getPrefixes(String namespaceURI) throws NamespaceException {
        String prefix = this.uris.get(namespaceURI);
        if (prefix == null) {
            return this.delegate.getPrefixes(namespaceURI);
        }
        ArrayList<String> prefixes = new ArrayList<String>();
        prefixes.add(prefix);
        return prefixes;
    }

    @Override
    public Collection<String> getPrefixes() {
        ArrayList<String> prefixes = new ArrayList<String>();
        Collection<String> uris = this.getURIs();
        for (String uri : uris) {
            Collection<String> uriPrefixes = this.getPrefixes(uri);
            prefixes.addAll(uriPrefixes);
        }
        return prefixes;
    }

    @Override
    public void registerNamespace(String prefix, String uri) {
        if (prefix.toLowerCase().startsWith(JCRNamespace.XML_PREFIX)) {
            throw new NamespaceException("Cannot map prefix " + prefix + " as it is reserved");
        }
        String existingUri = this.delegate.getNamespaceURI(prefix);
        if (existingUri != null) {
            throw new NamespaceException("Cannot map prefix " + prefix + " as it is already assigned to uri " + existingUri);
        }
        Collection<String> existingURIs = this.delegate.getURIs();
        if (!existingURIs.contains(uri)) {
            throw new NamespaceException("Cannot map prefix " + prefix + " to uri " + uri + " which does not exist");
        }
        this.prefixes.put(prefix, uri);
        this.uris.put(uri, prefix);
    }

    @Override
    public void unregisterNamespace(String prefix) {
        String uri = this.prefixes.get(prefix);
        if (uri != null) {
            this.uris.remove(uri);
        }
        this.prefixes.remove(prefix);
    }

    @Override
    public String getNamespaceURI(String prefix) throws NamespaceException {
        String uri = this.prefixes.get(prefix);
        if (uri == null) {
            return this.delegate.getNamespaceURI(prefix);
        }
        return uri;
    }

    @Override
    public Collection<String> getURIs() {
        return this.delegate.getURIs();
    }
}

