/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jcr.dictionary;

import java.util.ArrayList;
import java.util.Collection;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeIterator;
import javax.jcr.nodetype.NodeTypeManager;
import org.alfresco.jcr.dictionary.NodeTypeImpl;
import org.alfresco.jcr.dictionary.NodeTypeNameIterator;
import org.alfresco.jcr.dictionary.PropertyDefinitionImpl;
import org.alfresco.jcr.session.SessionImpl;
import org.alfresco.service.cmr.dictionary.ClassDefinition;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;

public class NodeTypeManagerImpl
implements NodeTypeManager {
    private SessionImpl session;
    private NamespaceService namespaceService;

    public NodeTypeManagerImpl(SessionImpl session, NamespaceService namespaceService) {
        this.session = session;
        this.namespaceService = namespaceService;
    }

    public SessionImpl getSession() {
        return this.session;
    }

    public NamespaceService getNamespaceService() {
        return this.namespaceService;
    }

    public NodeTypeImpl getNodeTypeImpl(QName nodeTypeName) {
        NodeTypeImpl nodeType = null;
        ClassDefinition definition = this.session.getRepositoryImpl().getServiceRegistry().getDictionaryService().getClass(nodeTypeName);
        if (definition != null) {
            nodeType = new NodeTypeImpl(this, definition);
        }
        return nodeType;
    }

    public PropertyDefinitionImpl getPropertyDefinitionImpl(QName propertyName) {
        PropertyDefinitionImpl propDef = null;
        PropertyDefinition definition = this.session.getRepositoryImpl().getServiceRegistry().getDictionaryService().getProperty(propertyName);
        if (definition != null) {
            propDef = new PropertyDefinitionImpl(this, definition);
        }
        return propDef;
    }

    public NodeType getNodeType(String nodeTypeName) throws NoSuchNodeTypeException, RepositoryException {
        QName name = QName.createQName(nodeTypeName, this.namespaceService);
        NodeTypeImpl nodeTypeImpl = this.getNodeTypeImpl(name);
        if (nodeTypeImpl == null) {
            throw new NoSuchNodeTypeException("Node type " + nodeTypeName + " does not exist");
        }
        return nodeTypeImpl;
    }

    public NodeTypeIterator getAllNodeTypes() throws RepositoryException {
        Collection<QName> typeNames = this.session.getRepositoryImpl().getServiceRegistry().getDictionaryService().getAllTypes();
        Collection<QName> aspectNames = this.session.getRepositoryImpl().getServiceRegistry().getDictionaryService().getAllAspects();
        ArrayList<QName> typesList = new ArrayList<QName>(typeNames.size() + aspectNames.size());
        typesList.addAll(typeNames);
        typesList.addAll(aspectNames);
        return new NodeTypeNameIterator(this, typesList);
    }

    public NodeTypeIterator getPrimaryNodeTypes() throws RepositoryException {
        Collection<QName> typeNames = this.session.getRepositoryImpl().getServiceRegistry().getDictionaryService().getAllTypes();
        ArrayList<QName> typesList = new ArrayList<QName>(typeNames.size());
        typesList.addAll(typeNames);
        return new NodeTypeNameIterator(this, typesList);
    }

    public NodeTypeIterator getMixinNodeTypes() throws RepositoryException {
        Collection<QName> typeNames = this.session.getRepositoryImpl().getServiceRegistry().getDictionaryService().getAllAspects();
        ArrayList<QName> typesList = new ArrayList<QName>(typeNames.size());
        typesList.addAll(typeNames);
        return new NodeTypeNameIterator(this, typesList);
    }
}

