/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jcr.dictionary;

import javax.jcr.Value;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.PropertyDefinition;
import org.alfresco.jcr.dictionary.DataTypeMap;
import org.alfresco.jcr.dictionary.NodeTypeManagerImpl;
import org.alfresco.jcr.item.ValueImpl;
import org.alfresco.jcr.item.property.JCRMixinTypesProperty;
import org.alfresco.jcr.item.property.JCRPrimaryTypeProperty;
import org.alfresco.model.ContentModel;
import org.alfresco.service.cmr.dictionary.ClassDefinition;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;

public class PropertyDefinitionImpl
implements PropertyDefinition {
    private NodeTypeManagerImpl typeManager;
    private org.alfresco.service.cmr.dictionary.PropertyDefinition propDef;

    public PropertyDefinitionImpl(NodeTypeManagerImpl typeManager, org.alfresco.service.cmr.dictionary.PropertyDefinition propDef) {
        this.typeManager = typeManager;
        this.propDef = propDef;
    }

    public int getRequiredType() {
        if (this.propDef.getName().equals(ContentModel.PROP_CONTENT)) {
            return DataTypeMap.convertDataTypeToPropertyType(DataTypeDefinition.CONTENT);
        }
        return DataTypeMap.convertDataTypeToPropertyType(this.propDef.getDataType().getName());
    }

    public String[] getValueConstraints() {
        return new String[0];
    }

    public Value[] getDefaultValues() {
        String defaultValue = this.propDef.getDefaultValue();
        if (defaultValue == null) {
            return null;
        }
        return new Value[]{new ValueImpl(this.typeManager.getSession(), this.getRequiredType(), defaultValue)};
    }

    public boolean isMultiple() {
        return this.propDef.isMultiValued();
    }

    public NodeType getDeclaringNodeType() {
        ClassDefinition declaringClass = this.propDef.getContainerClass();
        return this.typeManager.getNodeTypeImpl(declaringClass.getName());
    }

    public String getName() {
        return this.propDef.getName().toPrefixString(this.typeManager.getNamespaceService());
    }

    public boolean isAutoCreated() {
        return this.isMandatory();
    }

    public boolean isMandatory() {
        return this.propDef.isMandatory();
    }

    public int getOnParentVersion() {
        if (this.propDef.getName().equals(JCRPrimaryTypeProperty.PROPERTY_NAME) || this.propDef.getName().equals(JCRMixinTypesProperty.PROPERTY_NAME)) {
            return 4;
        }
        return 3;
    }

    public boolean isProtected() {
        return this.propDef.isProtected();
    }
}

