/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jcr.importer;

import javax.jcr.Credentials;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import org.alfresco.jcr.test.BaseJCRTest;
import org.springframework.core.io.ClassPathResource;

public class ImportTest
extends BaseJCRTest {
    protected Session superuserSession;

    protected void setUp() throws Exception {
        super.setUp();
        SimpleCredentials superuser = new SimpleCredentials("superuser", "".toCharArray());
        this.superuserSession = this.repository.login((Credentials)superuser, this.getWorkspace());
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.superuserSession.logout();
    }

    public void testSysImport() throws Exception {
        ClassPathResource sysview = new ClassPathResource("org/alfresco/jcr/test/sysview.xml");
        this.superuserSession.importXML("/testroot", sysview.getInputStream(), 0);
    }

    public void testDocImport() throws Exception {
        ClassPathResource sysview = new ClassPathResource("org/alfresco/jcr/test/docview.xml");
        this.superuserSession.importXML("/testroot", sysview.getInputStream(), 0);
    }

    public void testThrowCollision() throws Exception {
        ClassPathResource sysview = new ClassPathResource("org/alfresco/jcr/test/docview.xml");
        this.superuserSession.importXML("/testroot", sysview.getInputStream(), 1);
        try {
            this.superuserSession.importXML("/testroot", sysview.getInputStream(), 3);
            ImportTest.fail((String)"Failed to catch UUID collision");
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
    }
}

