/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jcr.importer;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import org.alfresco.jcr.dictionary.JCRNamespace;
import org.alfresco.jcr.importer.JCRDocXMLHandler;
import org.alfresco.jcr.importer.JCRSystemXMLHandler;
import org.alfresco.jcr.session.SessionImpl;
import org.alfresco.repo.importer.ImportContentHandler;
import org.alfresco.repo.importer.Importer;
import org.alfresco.service.cmr.view.ImporterException;
import org.alfresco.service.namespace.NamespaceException;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.NamespaceSupport;

public class JCRImportHandler
implements ImportContentHandler {
    private Importer importer;
    private SessionImpl session;
    private NamespaceContext namespaceContext;
    private ImportContentHandler targetHandler = null;

    public JCRImportHandler(SessionImpl session) {
        this.session = session;
        this.namespaceContext = new NamespaceContext();
    }

    public void setImporter(Importer importer) {
        this.importer = importer;
    }

    public InputStream importStream(String content) {
        return this.targetHandler.importStream(content);
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void startDocument() throws SAXException {
        this.namespaceContext.reset();
    }

    public void endDocument() throws SAXException {
        this.targetHandler.endDocument();
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        NamespacePrefixResolver resolver = this.session.getNamespaceResolver();
        Collection<String> uris = resolver.getURIs();
        if (!uris.contains(uri)) {
            throw new ImporterException("Namespace URI " + uri + " has not been registered with the repository");
        }
        this.namespaceContext.registerPrefix(prefix, uri);
    }

    public void endPrefixMapping(String prefix) throws SAXException {
    }

    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        this.namespaceContext.pushContext();
        if (this.targetHandler == null) {
            this.targetHandler = JCRNamespace.SV_URI.equals(uri) ? new JCRSystemXMLHandler(this.session, this.namespaceContext) : new JCRDocXMLHandler(this.session, this.namespaceContext);
            this.targetHandler.setImporter(this.importer);
            this.targetHandler.startDocument();
        }
        this.targetHandler.startElement(uri, localName, qName, atts);
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.targetHandler.endElement(uri, localName, qName);
        this.namespaceContext.popContext();
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        this.targetHandler.characters(ch, start, length);
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        this.targetHandler.characters(ch, start, length);
    }

    public void processingInstruction(String target, String data) throws SAXException {
        this.targetHandler.processingInstruction(target, data);
    }

    public void skippedEntity(String name) throws SAXException {
        this.targetHandler.skippedEntity(name);
    }

    public void warning(SAXParseException exception) throws SAXException {
        this.targetHandler.warning(exception);
    }

    public void error(SAXParseException exception) throws SAXException {
        this.targetHandler.error(exception);
    }

    public void fatalError(SAXParseException exception) throws SAXException {
        this.targetHandler.fatalError(exception);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NamespaceContext
    implements NamespacePrefixResolver {
        private final NamespaceSupport context = new NamespaceSupport();
        private static final String REMAPPED_DEFAULT_URI = " ";

        private NamespaceContext() {
        }

        private void reset() {
            this.context.reset();
        }

        private void pushContext() {
            this.context.pushContext();
        }

        private void popContext() {
            this.context.popContext();
        }

        private boolean registerPrefix(String prefix, String uri) {
            if ("".equals(uri)) {
                uri = REMAPPED_DEFAULT_URI;
            }
            return this.context.declarePrefix(prefix, uri);
        }

        @Override
        public String getNamespaceURI(String prefix) throws NamespaceException {
            String uri = this.context.getURI(prefix);
            if (uri == null) {
                throw new NamespaceException("Namespace prefix " + prefix + " not registered.");
            }
            if (REMAPPED_DEFAULT_URI.equals(uri)) {
                return "";
            }
            return uri;
        }

        @Override
        public Collection<String> getPrefixes(String namespaceURI) throws NamespaceException {
            String prefix;
            if ("".equals(namespaceURI)) {
                namespaceURI = REMAPPED_DEFAULT_URI;
            }
            if ((prefix = this.context.getPrefix(namespaceURI)) == null) {
                if (namespaceURI.equals(this.context.getURI(""))) {
                    prefix = "";
                } else {
                    throw new NamespaceException("Namespace URI " + namespaceURI + " not registered.");
                }
            }
            ArrayList<String> prefixes = new ArrayList<String>(1);
            prefixes.add(prefix);
            return prefixes;
        }

        @Override
        public Collection<String> getPrefixes() {
            return null;
        }

        @Override
        public Collection<String> getURIs() {
            return null;
        }
    }
}

