/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jcr.importer;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.List;
import java.util.Stack;
import javax.jcr.InvalidSerializedDataException;
import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import org.alfresco.jcr.dictionary.DataTypeMap;
import org.alfresco.jcr.dictionary.JCRNamespace;
import org.alfresco.jcr.exporter.JCRSystemXMLExporter;
import org.alfresco.jcr.importer.PropertyContext;
import org.alfresco.jcr.importer.ValueContext;
import org.alfresco.jcr.item.property.JCRMixinTypesProperty;
import org.alfresco.jcr.item.property.JCRPrimaryTypeProperty;
import org.alfresco.jcr.item.property.JCRUUIDProperty;
import org.alfresco.jcr.session.SessionImpl;
import org.alfresco.repo.importer.ImportContentHandler;
import org.alfresco.repo.importer.Importer;
import org.alfresco.repo.importer.view.ElementContext;
import org.alfresco.repo.importer.view.NodeContext;
import org.alfresco.repo.importer.view.ParentContext;
import org.alfresco.service.cmr.dictionary.AspectDefinition;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.InvalidTypeException;
import org.alfresco.service.cmr.dictionary.TypeDefinition;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.cmr.view.ImporterException;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.Base64;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class JCRSystemXMLHandler
implements ImportContentHandler {
    private Importer importer;
    private SessionImpl session;
    private NamespacePrefixResolver importResolver;
    private Stack<ElementContext> contextStack = new Stack();

    public JCRSystemXMLHandler(SessionImpl session, NamespacePrefixResolver importResolver) {
        this.session = session;
        this.importResolver = importResolver;
    }

    public void setImporter(Importer importer) {
        this.importer = importer;
    }

    public InputStream importStream(String content) {
        File contentFile = new File(content);
        try {
            FileInputStream contentStream = new FileInputStream(contentFile);
            return new Base64.InputStream((InputStream)contentStream, 8);
        }
        catch (FileNotFoundException e) {
            throw new ImporterException("Failed to retrieve import input stream on temporary content file " + content);
        }
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void startDocument() throws SAXException {
    }

    public void endDocument() throws SAXException {
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    public void endPrefixMapping(String prefix) throws SAXException {
    }

    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        try {
            QName elementName = QName.createQName(qName, this.importResolver);
            if (JCRSystemXMLExporter.NODE_QNAME.equals(elementName)) {
                this.processStartNode(elementName, atts);
            } else if (JCRSystemXMLExporter.PROPERTY_QNAME.equals(elementName)) {
                this.processStartProperty(elementName, atts);
            } else if (JCRSystemXMLExporter.VALUE_QNAME.equals(elementName)) {
                this.processStartValue(elementName, atts);
            }
        }
        catch (Exception e) {
            throw new SAXException("Failed to process element " + qName, e);
        }
    }

    private void processStartNode(QName elementName, Attributes atts) throws InvalidSerializedDataException {
        ParentContext parentContext = null;
        if (this.contextStack.empty()) {
            parentContext = new ParentContext(elementName, this.session.getRepositoryImpl().getServiceRegistry().getDictionaryService(), this.importer);
        } else {
            NodeContext parentNode = (NodeContext)this.contextStack.peek();
            if (parentNode.getNodeRef() == null) {
                NodeRef nodeRef = this.importer.importNode(parentNode);
                parentNode.setNodeRef(nodeRef);
            }
            parentContext = new ParentContext(elementName, parentNode);
        }
        NodeContext nodeContext = new NodeContext(elementName, parentContext, null);
        String name = atts.getValue(JCRSystemXMLExporter.NAME_QNAME.toPrefixString(this.importResolver));
        if (name == null) {
            throw new InvalidSerializedDataException("Mandatory sv:name attribute of element sv:node not present.");
        }
        nodeContext.setChildName(name);
        this.contextStack.push(nodeContext);
    }

    private void processStartProperty(QName elementName, Attributes atts) throws InvalidSerializedDataException {
        ElementContext context = this.contextStack.peek();
        if (!(context instanceof NodeContext)) {
            throw new InvalidSerializedDataException("Element " + elementName + " not expected.");
        }
        NodeContext parentNode = (NodeContext)context;
        String name = atts.getValue(JCRSystemXMLExporter.NAME_QNAME.toPrefixString(this.importResolver));
        if (name == null) {
            throw new InvalidSerializedDataException("Mandatory sv:name attribute of element sv:node not present.");
        }
        QName propertyName = QName.createQName(name, this.importResolver);
        QName dataType = null;
        String type = atts.getValue(JCRSystemXMLExporter.TYPE_QNAME.toPrefixString(this.importResolver));
        if (type == null) {
            throw new InvalidSerializedDataException("Mandatory sv:type attribute of element sv:node not present.");
        }
        try {
            dataType = DataTypeMap.convertPropertyTypeToDataType(PropertyType.valueFromName((String)type));
        }
        catch (IllegalArgumentException e) {
            throw new ImporterException("Type " + type + " is not known for property " + name);
        }
        PropertyContext propertyContext = new PropertyContext(elementName, parentNode, propertyName, dataType);
        this.contextStack.push(propertyContext);
    }

    private void processStartValue(QName elementName, Attributes atts) throws InvalidSerializedDataException {
        ElementContext context = this.contextStack.peek();
        if (!(context instanceof PropertyContext)) {
            throw new InvalidSerializedDataException("Element " + elementName + " not expected.");
        }
        PropertyContext property = (PropertyContext)context;
        property.startValue();
        ValueContext value = new ValueContext(elementName, property);
        this.contextStack.push(value);
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        try {
            ElementContext context = this.contextStack.peek();
            QName elementName = QName.createQName(qName, this.importResolver);
            if (!context.getElementName().equals(elementName)) {
                throw new InvalidSerializedDataException("Expected element " + context.getElementName() + " but was " + elementName);
            }
            if (JCRSystemXMLExporter.NODE_QNAME.equals(elementName)) {
                this.processEndNode((NodeContext)context);
            } else if (JCRSystemXMLExporter.PROPERTY_QNAME.equals(elementName)) {
                this.processEndProperty((PropertyContext)context);
            } else if (JCRSystemXMLExporter.VALUE_QNAME.equals(elementName)) {
                this.processEndValue((ValueContext)context);
            }
            this.contextStack.pop();
        }
        catch (Exception e) {
            throw new SAXException("Failed to process element " + qName, e);
        }
    }

    private void processEndNode(NodeContext node) {
        NodeRef nodeRef = node.getNodeRef();
        if (nodeRef == null) {
            nodeRef = node.getImporter().importNode(node);
            node.setNodeRef(nodeRef);
        }
        node.getImporter().childrenImported(nodeRef);
    }

    private void processEndProperty(PropertyContext context) throws InvalidSerializedDataException, RepositoryException {
        block14: {
            QName propertyName;
            block13: {
                propertyName = context.getName();
                if (context.isNull()) {
                    throw new InvalidSerializedDataException("Property " + propertyName + " must have a value");
                }
                if (!JCRPrimaryTypeProperty.PROPERTY_NAME.equals(propertyName)) break block13;
                if (context.isNull()) break block14;
                QName typeQName = QName.createQName(context.getValues().get(0).toString(), this.importResolver);
                TypeDefinition typeDef = context.getDictionaryService().getType(typeQName);
                if (typeDef == null) {
                    throw new InvalidTypeException(typeQName);
                }
                context.getNode().setTypeDefinition(typeDef);
                break block14;
            }
            if (JCRMixinTypesProperty.PROPERTY_NAME.equals(propertyName)) {
                List<StringBuffer> values = context.getValues();
                for (StringBuffer value : values) {
                    QName aspectQName = QName.createQName(value.toString(), this.importResolver);
                    if (JCRNamespace.JCR_URI.equals(aspectQName.getNamespaceURI()) || JCRNamespace.MIX_URI.equals(aspectQName.getNamespaceURI())) continue;
                    AspectDefinition aspectDef = context.getDictionaryService().getAspect(aspectQName);
                    if (aspectDef == null) {
                        throw new InvalidTypeException(aspectQName);
                    }
                    context.getNode().addAspect(aspectDef);
                }
            } else if (JCRUUIDProperty.PROPERTY_NAME.equals(propertyName)) {
                StringBuffer value = context.getValues().get(0);
                context.getNode().setUUID(value.toString());
            } else if (!JCRNamespace.JCR_URI.equals(propertyName.getNamespaceURI())) {
                NodeContext node = context.getNode();
                if (node.getTypeDefinition() == null) {
                    throw new InvalidSerializedDataException("Node jcr:primaryType property has not been specified.");
                }
                QName dataType = context.getType();
                DataTypeDefinition dataTypeDef = context.getDictionaryService().getDataType(dataType);
                if (dataTypeDef == null) {
                    throw new InvalidTypeException(dataType);
                }
                node.addDatatype(propertyName, dataTypeDef);
                if (context.isMultiValue()) {
                    node.addPropertyCollection(propertyName);
                }
                List<StringBuffer> values = context.getValues();
                for (StringBuffer value : values) {
                    Serializable objVal = (Serializable)this.session.getTypeConverter().convert(dataTypeDef, (Object)value.toString());
                    String strValue = DefaultTypeConverter.INSTANCE.convert(String.class, (Object)objVal);
                    node.addProperty(propertyName, strValue);
                }
            }
        }
    }

    private void processEndValue(ValueContext context) {
        PropertyContext property = context.getProperty();
        property.endValue();
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        ElementContext context = this.contextStack.peek();
        if (context instanceof ValueContext) {
            PropertyContext property = ((ValueContext)context).getProperty();
            property.appendCharacters(ch, start, length);
        }
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        ElementContext context = this.contextStack.peek();
        if (context instanceof ValueContext) {
            PropertyContext property = ((ValueContext)context).getProperty();
            property.appendCharacters(ch, start, length);
        }
    }

    public void processingInstruction(String target, String data) throws SAXException {
    }

    public void skippedEntity(String name) throws SAXException {
    }

    public void warning(SAXParseException exception) throws SAXException {
    }

    public void error(SAXParseException exception) throws SAXException {
    }

    public void fatalError(SAXParseException exception) throws SAXException {
    }
}

