/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jcr.item;

import java.util.StringTokenizer;
import org.alfresco.service.cmr.repository.Path;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;

public class JCRPath {
    private Path path;

    public JCRPath(NamespacePrefixResolver resolver, String strPath) {
        boolean root = false;
        int pos = 0;
        this.path = new Path();
        StringTokenizer tokenizer = new StringTokenizer(strPath, "/", true);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (pos == 0 && token.equals("/")) {
                root = true;
            } else if (!token.equals("/")) {
                if (root) {
                    this.path.append(new RootSimpleElement(resolver, token));
                    root = false;
                } else {
                    this.path.append(new SimpleElement(resolver, token));
                }
            }
            ++pos;
        }
    }

    public Path getPath() {
        return this.path;
    }

    public String toString() {
        return this.path.toString();
    }

    public static class RootSimpleElement
    extends SimpleElement {
        private static final long serialVersionUID = -4827016063963328324L;

        public RootSimpleElement(NamespacePrefixResolver resolver, String path) {
            super(resolver, path);
        }

        public String getElementString() {
            return "/" + super.getElementString();
        }

        public String getPrefixedString(NamespacePrefixResolver resolver) {
            return "/" + super.getPrefixedString(resolver);
        }
    }

    public static class SimpleElement
    extends Path.Element {
        private static final long serialVersionUID = -6510331182652872996L;
        private QName path;

        public SimpleElement(QName path) {
            this.path = path;
        }

        public SimpleElement(NamespacePrefixResolver resolver, String path) {
            this.path = QName.createQName(path, resolver);
        }

        public QName getQName() {
            return this.path;
        }

        public String getElementString() {
            return this.path.toString();
        }

        public String getPrefixedString(NamespacePrefixResolver resolver) {
            return this.path.toPrefixString(resolver);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SimpleElement)) {
                return false;
            }
            SimpleElement other = (SimpleElement)o;
            return this.path.equals(other.path);
        }

        public int hashCode() {
            return this.path.hashCode();
        }
    }
}

