/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jcr.item;

import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import javax.jcr.AccessDeniedException;
import javax.jcr.Item;
import javax.jcr.ItemNotFoundException;
import javax.jcr.ItemVisitor;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.PropertyDefinition;
import javax.jcr.version.VersionException;
import org.alfresco.jcr.api.JCRNodeRef;
import org.alfresco.jcr.dictionary.DataTypeMap;
import org.alfresco.jcr.dictionary.PropertyDefinitionImpl;
import org.alfresco.jcr.item.ItemImpl;
import org.alfresco.jcr.item.JCRPath;
import org.alfresco.jcr.item.NodeImpl;
import org.alfresco.jcr.item.ValueImpl;
import org.alfresco.jcr.util.JCRProxyFactory;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.InvalidTypeException;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.Path;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.cmr.repository.datatype.TypeConversionException;
import org.alfresco.service.namespace.QName;

public class PropertyImpl
extends ItemImpl
implements Property {
    private NodeImpl node;
    private QName name;
    private Property proxy = null;

    public PropertyImpl(NodeImpl node, QName name) {
        super(node.session);
        this.node = node;
        this.name = name;
    }

    public Property getProxy() {
        if (this.proxy == null) {
            this.proxy = (Property)JCRProxyFactory.create(this, Property.class, this.session);
        }
        return this.proxy;
    }

    public void remove() throws VersionException, LockException, ConstraintViolationException, RepositoryException {
        this.setValue((Value)null);
    }

    public void setValue(Value value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        this.setPropertyValue(value, -1);
    }

    public void setValue(Value[] values) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        this.setPropertyValue(values, -1);
    }

    public void setValue(String value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        this.setPropertyValue(value, -1);
    }

    public void setValue(String[] values) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        this.setPropertyValue(values, -1);
    }

    public void setValue(InputStream value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        this.setPropertyValue(value, -1);
    }

    public void setValue(long value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        this.setPropertyValue(value, -1);
    }

    public void setValue(double value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        this.setPropertyValue(value, -1);
    }

    public void setValue(Calendar value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        this.setPropertyValue(value == null ? null : value.getTime(), -1);
    }

    public void setValue(boolean value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        this.setPropertyValue(value, -1);
    }

    public void setValue(Node value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        this.setPropertyValue(value == null ? null : JCRNodeRef.getNodeRef(value), -1);
    }

    public Value getValue() throws ValueFormatException, RepositoryException {
        this.checkSingleValued();
        ValueImpl valueImpl = new ValueImpl(this.session, this.getType(), this.getPropertyValue());
        return valueImpl;
    }

    public Value[] getValues() throws ValueFormatException, RepositoryException {
        this.checkMultiValued();
        Collection values = (Collection)this.getPropertyValue();
        int type = this.getType();
        ArrayList<ValueImpl> jcrValues = new ArrayList<ValueImpl>(values.size());
        for (Object value : values) {
            if (value == null) continue;
            jcrValues.add(new ValueImpl(this.session, type, value));
        }
        return jcrValues.toArray(new Value[jcrValues.size()]);
    }

    public String getString() throws ValueFormatException, RepositoryException {
        this.checkSingleValued();
        return this.session.getTypeConverter().stringValue(this.getPropertyValue());
    }

    public InputStream getStream() throws ValueFormatException, RepositoryException {
        this.checkSingleValued();
        return this.session.getTypeConverter().streamValue(this.getPropertyValue());
    }

    public long getLong() throws ValueFormatException, RepositoryException {
        this.checkSingleValued();
        return this.session.getTypeConverter().longValue(this.getPropertyValue());
    }

    public double getDouble() throws ValueFormatException, RepositoryException {
        this.checkSingleValued();
        return this.session.getTypeConverter().doubleValue(this.getPropertyValue());
    }

    public Calendar getDate() throws ValueFormatException, RepositoryException {
        this.checkSingleValued();
        return this.session.getTypeConverter().dateValue(this.getPropertyValue());
    }

    public boolean getBoolean() throws ValueFormatException, RepositoryException {
        this.checkSingleValued();
        return this.session.getTypeConverter().booleanValue(this.getPropertyValue());
    }

    public Node getNode() throws ValueFormatException, RepositoryException {
        this.checkSingleValued();
        return this.session.getTypeConverter().referenceValue(this.getPropertyValue()).getProxy();
    }

    public long getLength() throws ValueFormatException, RepositoryException {
        this.checkSingleValued();
        return this.getPropertyLength(this.getPropertyValue());
    }

    public long[] getLengths() throws ValueFormatException, RepositoryException {
        this.checkMultiValued();
        Collection values = (Collection)this.getPropertyValue();
        long[] lengths = new long[values.size()];
        int i = 0;
        for (Object value : values) {
            lengths[i++] = this.getPropertyLength(value);
        }
        return lengths;
    }

    public PropertyDefinition getDefinition() throws RepositoryException {
        PropertyDefinitionImpl propDefImpl = new PropertyDefinitionImpl(this.session.getTypeManager(), this.getPropertyDefinition());
        return propDefImpl;
    }

    public int getType() throws RepositoryException {
        return DataTypeMap.convertDataTypeToPropertyType(this.getPropertyDefinition().getDataType().getName());
    }

    public String getName() throws RepositoryException {
        return this.name.toPrefixString(this.session.getNamespaceResolver());
    }

    public boolean isNode() {
        return false;
    }

    public Node getParent() throws ItemNotFoundException, AccessDeniedException, RepositoryException {
        return this.node.getProxy();
    }

    public String getPath() throws RepositoryException {
        NodeService nodeService = this.session.getRepositoryImpl().getServiceRegistry().getNodeService();
        Path path = nodeService.getPath(this.node.getNodeRef());
        path.append(new JCRPath.SimpleElement(this.name));
        return path.toPrefixString(this.session.getNamespaceResolver());
    }

    public int getDepth() throws RepositoryException {
        NodeService nodeService = this.session.getRepositoryImpl().getServiceRegistry().getNodeService();
        Path path = nodeService.getPath(this.node.getNodeRef());
        return path.size();
    }

    public Item getAncestor(int depth) throws ItemNotFoundException, AccessDeniedException, RepositoryException {
        int propertyDepth = this.getDepth();
        if (depth < 0 || depth > propertyDepth) {
            throw new ItemNotFoundException("Ancestor at depth " + depth + " not found for property " + this.name);
        }
        if (depth == propertyDepth) {
            return this.getProxy();
        }
        return this.node.getAncestor(depth - 1);
    }

    public boolean isSame(Item otherItem) throws RepositoryException {
        return this.getProxy().equals(otherItem);
    }

    public void accept(ItemVisitor visitor) throws RepositoryException {
        visitor.visit(this.getProxy());
    }

    protected NodeImpl getNodeImpl() {
        return this.node;
    }

    protected QName getPropertyName() {
        return this.name;
    }

    protected Object getPropertyValue() throws RepositoryException {
        Object value = null;
        if (this.getPropertyDefinition().getDataType().getName().equals(DataTypeDefinition.CONTENT)) {
            ContentService contentService = this.node.session.getRepositoryImpl().getServiceRegistry().getContentService();
            value = contentService.getReader(this.node.getNodeRef(), this.name);
            if (value == null) {
                throw new RepositoryException("Property " + this.name + " has been removed.");
            }
        } else {
            NodeService nodeService = this.node.session.getRepositoryImpl().getServiceRegistry().getNodeService();
            value = nodeService.getProperty(this.node.getNodeRef(), this.name);
            if (value == null) {
                throw new RepositoryException("Property " + this.name + " has been removed.");
            }
            boolean multiValued = this.getPropertyDefinition().isMultiValued();
            if (multiValued != value instanceof Collection) {
                throw new RepositoryException("Alfresco value does not match multi-valued definition of " + multiValued);
            }
        }
        return value;
    }

    private long getPropertyLength(Object value) throws ValueFormatException, RepositoryException {
        if (value instanceof ContentReader) {
            return ((ContentReader)value).getSize();
        }
        if (value instanceof InputStream) {
            return -1L;
        }
        String strValue = DefaultTypeConverter.INSTANCE.convert(String.class, value);
        return strValue.length();
    }

    protected void setPropertyValue(Object value, int type) throws RepositoryException {
        this.checkSingleValued();
        Object castValue = this.castValue(value, type);
        this.writeValue(castValue);
    }

    protected void setPropertyValue(Object[] values, int type) throws RepositoryException {
        this.checkMultiValued();
        ArrayList<Object> castValues = null;
        if (values != null) {
            castValues = new ArrayList<Object>(values.length);
            for (Object value : values) {
                Object castValue = this.castValue(value, type);
                castValues.add(castValue);
            }
        }
        this.writeValue(castValues);
    }

    private Object castValue(Object value, int type) throws RepositoryException {
        if (value instanceof Value) {
            value = ValueImpl.getValue((Value)value);
        }
        DataTypeDefinition dataTypeDef = this.getPropertyDefinition().getDataType();
        if (type != -1 && dataTypeDef.getName().equals(DataTypeDefinition.ANY)) {
            QName dataTypeName = DataTypeMap.convertPropertyTypeToDataType(type);
            DictionaryService dictionaryService = this.session.getRepositoryImpl().getServiceRegistry().getDictionaryService();
            dataTypeDef = dictionaryService.getDataType(dataTypeName);
            if (!dataTypeName.equals(DataTypeDefinition.CONTENT)) {
                value = this.session.getTypeConverter().convert(dataTypeDef, value);
            }
        }
        if (dataTypeDef.getName().equals(DataTypeDefinition.CONTENT)) {
            value = this.session.getTypeConverter().streamValue(value);
        }
        return value;
    }

    private void writeValue(Object value) throws ValueFormatException {
        if (value instanceof InputStream) {
            try {
                ContentService contentService = this.session.getRepositoryImpl().getServiceRegistry().getContentService();
                ContentWriter writer = contentService.getWriter(this.node.getNodeRef(), this.name, true);
                writer.setMimetype("application/octet-stream");
                writer.putContent((InputStream)value);
            }
            catch (InvalidTypeException e) {
                throw new ValueFormatException((Throwable)((Object)e));
            }
        }
        try {
            NodeService nodeService = this.session.getRepositoryImpl().getServiceRegistry().getNodeService();
            nodeService.setProperty(this.node.getNodeRef(), this.name, (Serializable)value);
        }
        catch (TypeConversionException e) {
            throw new ValueFormatException((Throwable)e);
        }
    }

    private void checkSingleValued() throws ValueFormatException {
        if (this.getPropertyDefinition().isMultiValued()) {
            throw new ValueFormatException("Property " + this.name + " is multi-valued.");
        }
    }

    private void checkMultiValued() throws ValueFormatException {
        if (!this.getPropertyDefinition().isMultiValued()) {
            throw new ValueFormatException("Property " + this.name + " is single-valued.");
        }
    }

    private org.alfresco.service.cmr.dictionary.PropertyDefinition getPropertyDefinition() {
        DictionaryService dictionary = this.session.getRepositoryImpl().getServiceRegistry().getDictionaryService();
        return dictionary.getProperty(this.name);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof PropertyImpl)) {
            return false;
        }
        PropertyImpl other = (PropertyImpl)obj;
        return this.name.equals(other.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }
}

