/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jcr.item.property;

import java.util.ArrayList;
import java.util.Set;
import javax.jcr.RepositoryException;
import org.alfresco.jcr.dictionary.JCRNamespace;
import org.alfresco.jcr.dictionary.NodeTypeImpl;
import org.alfresco.jcr.item.NodeImpl;
import org.alfresco.jcr.item.PropertyImpl;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.QName;

public class JCRMixinTypesProperty
extends PropertyImpl {
    public static QName PROPERTY_NAME = QName.createQName(JCRNamespace.JCR_URI, "mixinTypes");

    public JCRMixinTypesProperty(NodeImpl node) {
        super(node, PROPERTY_NAME);
    }

    protected Object getPropertyValue() throws RepositoryException {
        NodeImpl nodeImpl = this.getNodeImpl();
        NodeService nodeService = nodeImpl.getSessionImpl().getRepositoryImpl().getServiceRegistry().getNodeService();
        Set<QName> aspects = nodeService.getAspects(nodeImpl.getNodeRef());
        ArrayList<String> aspectNames = new ArrayList<String>(aspects.size() + 1);
        for (QName aspect : aspects) {
            aspectNames.add(aspect.toPrefixString(nodeImpl.getSessionImpl().getNamespaceResolver()));
        }
        aspectNames.add(NodeTypeImpl.MIX_REFERENCEABLE.toPrefixString(nodeImpl.getSessionImpl().getNamespaceResolver()));
        return aspectNames;
    }
}

