/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jcr.query;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.PropertyDefinition;
import javax.jcr.query.QueryResult;
import javax.jcr.query.RowIterator;
import org.alfresco.jcr.item.NodeRefNodeIteratorImpl;
import org.alfresco.jcr.query.NodeRefRowIteratorImpl;
import org.alfresco.jcr.query.QueryManagerImpl;
import org.alfresco.jcr.session.SessionImpl;
import org.alfresco.jcr.util.JCRProxyFactory;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeRefListQueryResultImpl
implements QueryResult {
    private SessionImpl session;
    private List<NodeRef> nodeRefs;
    private NodeService nodeService;
    private Map<QName, PropertyDefinition> columns = null;
    private QueryResult proxy = null;

    public NodeRefListQueryResultImpl(SessionImpl session, List<NodeRef> nodeRefs) {
        this.session = session;
        this.nodeRefs = nodeRefs;
        this.nodeService = session.getRepositoryImpl().getServiceRegistry().getNodeService();
    }

    public QueryResult getProxy() {
        if (this.proxy == null) {
            this.proxy = (QueryResult)JCRProxyFactory.create(this, QueryResult.class, this.session);
        }
        return this.proxy;
    }

    public String[] getColumnNames() throws RepositoryException {
        Map<QName, PropertyDefinition> columns = this.getColumnDefinitions();
        String[] names = new String[columns.size()];
        int i = 0;
        for (QName columnName : columns.keySet()) {
            names[i++] = columnName.toPrefixString(this.session.getNamespaceResolver());
        }
        return names;
    }

    public RowIterator getRows() throws RepositoryException {
        return new NodeRefRowIteratorImpl(this.session, this.getColumnDefinitions(), this.nodeRefs).getProxy();
    }

    public NodeIterator getNodes() throws RepositoryException {
        return new NodeRefNodeIteratorImpl(this.session, this.nodeRefs);
    }

    private Map<QName, PropertyDefinition> getColumnDefinitions() throws RepositoryException {
        if (this.columns == null) {
            this.columns = new HashMap<QName, PropertyDefinition>();
            if (this.nodeRefs.size() > 0) {
                PropertyDefinition[] propDefs;
                QName type = this.nodeService.getType(this.nodeRefs.get(0));
                NodeType nodeType = this.session.getTypeManager().getNodeType(type.toPrefixString(this.session.getNamespaceResolver()));
                for (PropertyDefinition propDef : propDefs = nodeType.getPropertyDefinitions()) {
                    if (propDef.isMultiple()) continue;
                    this.columns.put(QName.createQName(propDef.getName(), this.session.getNamespaceResolver()), propDef);
                }
                Set<QName> aspects = this.nodeService.getAspects(this.nodeRefs.get(0));
                for (QName aspect : aspects) {
                    NodeType nodeAspect = this.session.getTypeManager().getNodeType(aspect.toPrefixString(this.session.getNamespaceResolver()));
                    for (PropertyDefinition propDef : propDefs = nodeAspect.getPropertyDefinitions()) {
                        if (propDef.isMultiple()) continue;
                        this.columns.put(QName.createQName(propDef.getName(), this.session.getNamespaceResolver()), propDef);
                    }
                }
            }
            this.columns.put(QueryManagerImpl.JCRPATH_COLUMN, null);
            this.columns.put(QueryManagerImpl.JCRSCORE_COLUMN, null);
        }
        return this.columns;
    }
}

