/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jcr.query;

import java.io.Serializable;
import java.util.Map;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.nodetype.PropertyDefinition;
import javax.jcr.query.Row;
import org.alfresco.jcr.item.NodeImpl;
import org.alfresco.jcr.item.ValueImpl;
import org.alfresco.jcr.query.QueryManagerImpl;
import org.alfresco.jcr.session.SessionImpl;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyMapRowImpl
implements Row {
    private SessionImpl session;
    private Map<QName, PropertyDefinition> columns;
    private NodeRef nodeRef;
    private Map<QName, Serializable> properties;

    public PropertyMapRowImpl(SessionImpl session, Map<QName, PropertyDefinition> columns, NodeRef nodeRef, Map<QName, Serializable> properties) {
        this.session = session;
        this.columns = columns;
        this.nodeRef = nodeRef;
        this.properties = properties;
    }

    public Value[] getValues() throws RepositoryException {
        Value[] values = new Value[this.columns.size() + 2];
        int i = 0;
        for (QName propertyName : this.columns.keySet()) {
            values[i++] = this.createValue(propertyName);
        }
        return values;
    }

    public Value getValue(String propertyName) throws ItemNotFoundException, RepositoryException {
        QName propertyQName = QName.createQName(propertyName, this.session.getNamespaceResolver());
        if (!this.columns.containsKey(propertyQName)) {
            throw new ItemNotFoundException("Column " + propertyName + " does not exist");
        }
        return this.createValue(propertyQName);
    }

    private Value createValue(QName propertyName) throws RepositoryException {
        ValueImpl value = null;
        if (propertyName.equals(QueryManagerImpl.JCRPATH_COLUMN)) {
            Node node = new NodeImpl(this.session, this.nodeRef).getProxy();
            value = new ValueImpl(this.session, 1, node.getPath());
        } else if (propertyName.equals(QueryManagerImpl.JCRSCORE_COLUMN)) {
            value = new ValueImpl(this.session, 3, 0L);
        } else {
            Serializable objValue = this.properties.get(propertyName);
            if (objValue != null) {
                PropertyDefinition propDef = this.columns.get(propertyName);
                value = new ValueImpl(this.session, propDef.getRequiredType(), objValue);
            }
        }
        return value;
    }
}

