/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jcr.session;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.jcr.AccessDeniedException;
import javax.jcr.InvalidItemStateException;
import javax.jcr.InvalidSerializedDataException;
import javax.jcr.ItemExistsException;
import javax.jcr.NamespaceRegistry;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.Workspace;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NodeTypeManager;
import javax.jcr.observation.ObservationManager;
import javax.jcr.query.QueryManager;
import javax.jcr.version.Version;
import javax.jcr.version.VersionException;
import org.alfresco.jcr.item.ItemResolver;
import org.alfresco.jcr.item.JCRPath;
import org.alfresco.jcr.query.QueryManagerImpl;
import org.alfresco.jcr.session.SessionImpl;
import org.alfresco.jcr.util.JCRProxyFactory;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.CopyService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.Path;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.ParameterCheck;
import org.xml.sax.ContentHandler;

public class WorkspaceImpl
implements Workspace {
    private SessionImpl session;
    private Workspace proxy = null;
    private QueryManagerImpl queryManager = null;

    public WorkspaceImpl(SessionImpl session) {
        this.session = session;
    }

    public Workspace getProxy() {
        if (this.proxy == null) {
            this.proxy = (Workspace)JCRProxyFactory.create(this, Workspace.class, this.session);
        }
        return this.proxy;
    }

    public Session getSession() {
        return this.session.getProxy();
    }

    public String getName() {
        return this.session.getWorkspaceStore().getIdentifier();
    }

    public void copy(String srcAbsPath, String destAbsPath) throws ConstraintViolationException, VersionException, AccessDeniedException, PathNotFoundException, ItemExistsException, LockException, RepositoryException {
        ParameterCheck.mandatoryString((String)"srcAbsPath", (String)srcAbsPath);
        ParameterCheck.mandatoryString((String)"destAbsPath", (String)destAbsPath);
        NodeService nodeService = this.session.getRepositoryImpl().getServiceRegistry().getNodeService();
        NodeRef rootRef = nodeService.getRootNode(this.session.getWorkspaceStore());
        NodeRef sourceRef = ItemResolver.getNodeRef(this.session, rootRef, srcAbsPath);
        if (sourceRef == null) {
            throw new PathNotFoundException("Source path " + srcAbsPath + " cannot be found.");
        }
        NodeRef destRef = null;
        QName destName = null;
        Path destPath = new JCRPath(this.session.getNamespaceResolver(), destAbsPath).getPath();
        if (destPath.size() == 1) {
            destRef = rootRef;
            destName = ((JCRPath.SimpleElement)destPath.get(0)).getQName();
        } else {
            Path destParentPath = destPath.subPath(destPath.size() - 2);
            destRef = ItemResolver.getNodeRef(this.session, rootRef, destParentPath.toPrefixString(this.session.getNamespaceResolver()));
            if (destRef == null) {
                throw new PathNotFoundException("Destination path " + destParentPath + " cannot be found.");
            }
            destName = ((JCRPath.SimpleElement)destPath.get(destPath.size() - 1)).getQName();
        }
        if (destName.getLocalName().indexOf(91) != -1 || destName.getLocalName().indexOf(93) != -1) {
            throw new RepositoryException("Node name '" + destName + "' is invalid");
        }
        ChildAssociationRef childAssocRef = nodeService.getPrimaryParent(sourceRef);
        CopyService copyService = this.session.getRepositoryImpl().getServiceRegistry().getCopyService();
        copyService.copy(sourceRef, destRef, childAssocRef.getTypeQName(), destName);
        this.session.save();
    }

    public void copy(String srcWorkspace, String srcAbsPath, String destAbsPath) throws NoSuchWorkspaceException, ConstraintViolationException, VersionException, AccessDeniedException, PathNotFoundException, ItemExistsException, LockException, RepositoryException {
        throw new UnsupportedRepositoryOperationException();
    }

    public void clone(String srcWorkspace, String srcAbsPath, String destAbsPath, boolean removeExisting) throws NoSuchWorkspaceException, ConstraintViolationException, VersionException, AccessDeniedException, PathNotFoundException, ItemExistsException, LockException, RepositoryException {
        throw new UnsupportedRepositoryOperationException();
    }

    public void move(String srcAbsPath, String destAbsPath) throws ConstraintViolationException, VersionException, AccessDeniedException, PathNotFoundException, ItemExistsException, LockException, RepositoryException {
        this.session.move(srcAbsPath, destAbsPath);
        this.session.save();
    }

    public void restore(Version[] versions, boolean removeExisting) throws ItemExistsException, UnsupportedRepositoryOperationException, VersionException, LockException, InvalidItemStateException, RepositoryException {
        throw new UnsupportedRepositoryOperationException();
    }

    public QueryManager getQueryManager() throws RepositoryException {
        if (this.queryManager == null) {
            this.queryManager = new QueryManagerImpl(this.session);
        }
        return this.queryManager;
    }

    public NamespaceRegistry getNamespaceRegistry() throws RepositoryException {
        return this.session.getRepositoryImpl().getNamespaceRegistry();
    }

    public NodeTypeManager getNodeTypeManager() throws RepositoryException {
        return this.session.getTypeManager();
    }

    public ObservationManager getObservationManager() throws UnsupportedRepositoryOperationException, RepositoryException {
        throw new UnsupportedRepositoryOperationException();
    }

    public String[] getAccessibleWorkspaceNames() throws RepositoryException {
        NodeService nodeService = this.session.getRepositoryImpl().getServiceRegistry().getNodeService();
        List<StoreRef> storeRefs = nodeService.getStores();
        ArrayList<String> workspaceStores = new ArrayList<String>();
        for (StoreRef storeRef : storeRefs) {
            if (!storeRef.getProtocol().equals("workspace")) continue;
            workspaceStores.add(storeRef.getIdentifier());
        }
        return workspaceStores.toArray(new String[workspaceStores.size()]);
    }

    public ContentHandler getImportContentHandler(String parentAbsPath, int uuidBehavior) throws PathNotFoundException, ConstraintViolationException, VersionException, LockException, AccessDeniedException, RepositoryException {
        return this.session.getImportContentHandler(parentAbsPath, uuidBehavior);
    }

    public void importXML(String parentAbsPath, InputStream in, int uuidBehavior) throws IOException, PathNotFoundException, ItemExistsException, ConstraintViolationException, InvalidSerializedDataException, LockException, AccessDeniedException, RepositoryException {
        this.session.importXML(parentAbsPath, in, uuidBehavior);
    }
}

