/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jcr.test;

import java.util.ArrayList;
import java.util.Properties;
import org.alfresco.repo.importer.ImporterBootstrap;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.security.authentication.MutableAuthenticationDao;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.cmr.view.ImporterService;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.transaction.TransactionService;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class TestData {
    public static final String TEST_WORKSPACE = "test";

    public static void main(String[] args) {
        ClassPathXmlApplicationContext context = new ClassPathXmlApplicationContext("org/alfresco/jcr/test/test-context.xml");
        TestData.generateTestData((ApplicationContext)context, TEST_WORKSPACE);
        System.out.println("Generated TCK test data to workspace: test");
        System.exit(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void generateTestData(ApplicationContext applicationContext, String workspaceName) {
        MutableAuthenticationDao authDAO = (MutableAuthenticationDao)applicationContext.getBean("alfDaoImpl");
        if (!authDAO.userExists("superuser")) {
            authDAO.createUser("superuser", "".toCharArray());
        }
        if (!authDAO.userExists("user")) {
            authDAO.createUser("user", "".toCharArray());
        }
        if (!authDAO.userExists("anonymous")) {
            authDAO.createUser("anonymous", "".toCharArray());
        }
        try {
            AuthenticationComponent authenticationComponent = (AuthenticationComponent)applicationContext.getBean("authenticationComponent");
            authenticationComponent.setSystemUserAsCurrentUser();
            try {
                StoreRef storeRef = new StoreRef("workspace", workspaceName);
                ImporterBootstrap bootstrap = new ImporterBootstrap();
                bootstrap.setAuthenticationComponent((AuthenticationComponent)applicationContext.getBean("authenticationComponent"));
                bootstrap.setImporterService((ImporterService)applicationContext.getBean(ServiceRegistry.IMPORTER_SERVICE.getLocalName()));
                bootstrap.setNodeService((NodeService)applicationContext.getBean(ServiceRegistry.NODE_SERVICE.getLocalName()));
                bootstrap.setNamespaceService((NamespaceService)applicationContext.getBean(ServiceRegistry.NAMESPACE_SERVICE.getLocalName()));
                bootstrap.setTransactionService((TransactionService)applicationContext.getBean(ServiceRegistry.TRANSACTION_SERVICE.getLocalName()));
                bootstrap.setStoreUrl(storeRef.toString());
                ArrayList<Properties> views = new ArrayList<Properties>();
                Properties testView = new Properties();
                testView.setProperty("path", "/");
                testView.setProperty("location", "org/alfresco/jcr/test/testData.xml");
                views.add(testView);
                bootstrap.setBootstrapViews(views);
                bootstrap.bootstrap();
                authenticationComponent.setSystemUserAsCurrentUser();
                PermissionService permissionService = (PermissionService)applicationContext.getBean(ServiceRegistry.PERMISSIONS_SERVICE.getLocalName());
                NodeService nodeService = (NodeService)applicationContext.getBean(ServiceRegistry.NODE_SERVICE.getLocalName());
                permissionService.setPermission(nodeService.getRootNode(storeRef), "superuser", "All", true);
                permissionService.setPermission(nodeService.getRootNode(storeRef), "anonymous", "Read", true);
                permissionService.setPermission(nodeService.getRootNode(storeRef), "user", "Read", true);
                permissionService.setPermission(nodeService.getRootNode(storeRef), "user", "Write", true);
            }
            finally {
                authenticationComponent.clearCurrentSecurityContext();
            }
        }
        catch (RuntimeException e) {
            System.out.println("Exception: " + e);
            e.printStackTrace();
            throw e;
        }
    }
}

