/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.action;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.action.ActionConditionImpl;
import org.alfresco.repo.action.ActionImpl;
import org.alfresco.repo.action.ActionModel;
import org.alfresco.repo.action.ActionTransactionListener;
import org.alfresco.repo.action.AsynchronousActionExecutionQueue;
import org.alfresco.repo.action.CompositeActionImpl;
import org.alfresco.repo.action.RuntimeActionService;
import org.alfresco.repo.action.evaluator.ActionConditionEvaluator;
import org.alfresco.repo.action.executer.ActionExecuter;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ActionCondition;
import org.alfresco.service.cmr.action.ActionConditionDefinition;
import org.alfresco.service.cmr.action.ActionDefinition;
import org.alfresco.service.cmr.action.ActionService;
import org.alfresco.service.cmr.action.ActionServiceException;
import org.alfresco.service.cmr.action.CompositeAction;
import org.alfresco.service.cmr.action.ParameterizedItem;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.namespace.DynamicNamespacePrefixResolver;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.alfresco.util.GUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActionServiceImpl
implements ActionService,
RuntimeActionService,
ApplicationContextAware {
    private static final String POST_TRANSACTION_PENDING_ACTIONS = "postTransactionPendingActions";
    private static final String ERR_FAIL = "The action failed to execute due to an error.";
    private static final QName ASSOC_NAME_ACTIONS = QName.createQName("http://www.alfresco.org/model/action/1.0", "actions");
    private static Log logger = LogFactory.getLog(ActionServiceImpl.class);
    ThreadLocal<Set<String>> currentActionChain = new ThreadLocal();
    private ApplicationContext applicationContext;
    private NodeService nodeService;
    private SearchService searchService;
    private DictionaryService dictionaryService;
    private AuthenticationComponent authenticationComponent;
    private AsynchronousActionExecutionQueue asynchronousActionExecutionQueue;
    private ActionTransactionListener transactionListener = new ActionTransactionListener(this);
    private Map<String, ActionConditionDefinition> conditionDefinitions = new HashMap<String, ActionConditionDefinition>();
    private Map<String, ActionDefinition> actionDefinitions = new HashMap<String, ActionDefinition>();

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }

    public void setAuthenticationComponent(AuthenticationComponent authenticationComponent) {
        this.authenticationComponent = authenticationComponent;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public void setAsynchronousActionExecutionQueue(AsynchronousActionExecutionQueue asynchronousActionExecutionQueue) {
        this.asynchronousActionExecutionQueue = asynchronousActionExecutionQueue;
    }

    @Override
    public AsynchronousActionExecutionQueue getAsynchronousActionExecutionQueue() {
        return this.asynchronousActionExecutionQueue;
    }

    private NodeRef getSavedActionFolderRef(NodeRef nodeRef) {
        List<ChildAssociationRef> assocs = this.nodeService.getChildAssocs(nodeRef, RegexQNamePattern.MATCH_ALL, ActionModel.ASSOC_ACTION_FOLDER);
        if (assocs.size() != 1) {
            throw new ActionServiceException("Unable to retrieve the saved action folder reference.");
        }
        return assocs.get(0).getChildRef();
    }

    @Override
    public ActionDefinition getActionDefinition(String name) {
        return this.actionDefinitions.get(name);
    }

    @Override
    public List<ActionDefinition> getActionDefinitions() {
        return new ArrayList<ActionDefinition>(this.actionDefinitions.values());
    }

    @Override
    public List<ActionDefinition> getActionDefinitions(NodeRef nodeRef) {
        if (nodeRef == null) {
            return this.getActionDefinitions();
        }
        QName nodeType = this.nodeService.getType(nodeRef);
        ArrayList<ActionDefinition> result = new ArrayList<ActionDefinition>();
        block0: for (ActionDefinition actionDefinition : this.getActionDefinitions()) {
            List<QName> appliciableTypes = actionDefinition.getApplicableTypes();
            if (appliciableTypes != null && !appliciableTypes.isEmpty()) {
                for (QName applicableType : actionDefinition.getApplicableTypes()) {
                    if (!this.dictionaryService.isSubClass(nodeType, applicableType)) continue;
                    result.add(actionDefinition);
                    continue block0;
                }
                continue;
            }
            result.add(actionDefinition);
        }
        return result;
    }

    @Override
    public ActionConditionDefinition getActionConditionDefinition(String name) {
        return this.conditionDefinitions.get(name);
    }

    @Override
    public List<ActionConditionDefinition> getActionConditionDefinitions() {
        return new ArrayList<ActionConditionDefinition>(this.conditionDefinitions.values());
    }

    @Override
    public ActionCondition createActionCondition(String name) {
        return new ActionConditionImpl(GUID.generate(), name);
    }

    @Override
    public ActionCondition createActionCondition(String name, Map<String, Serializable> params) {
        ActionCondition condition = this.createActionCondition(name);
        condition.setParameterValues(params);
        return condition;
    }

    @Override
    public Action createAction(String name) {
        return new ActionImpl(GUID.generate(), name, null);
    }

    @Override
    public Action createAction(String name, Map<String, Serializable> params) {
        Action action = this.createAction(name);
        action.setParameterValues(params);
        return action;
    }

    @Override
    public CompositeAction createCompositeAction() {
        return new CompositeActionImpl(GUID.generate(), null);
    }

    @Override
    public boolean evaluateAction(Action action, NodeRef actionedUponNodeRef) {
        boolean result = true;
        if (action.hasActionConditions()) {
            List<ActionCondition> actionConditions = action.getActionConditions();
            for (ActionCondition condition : actionConditions) {
                result = result && this.evaluateActionCondition(condition, actionedUponNodeRef);
            }
        }
        return result;
    }

    @Override
    public boolean evaluateActionCondition(ActionCondition condition, NodeRef actionedUponNodeRef) {
        boolean result = false;
        ActionConditionEvaluator evaluator = (ActionConditionEvaluator)this.applicationContext.getBean(condition.getActionConditionDefinitionName());
        result = evaluator.evaluate(condition, actionedUponNodeRef);
        return result;
    }

    @Override
    public void executeAction(Action action, NodeRef actionedUponNodeRef, boolean checkConditions) {
        this.executeAction(action, actionedUponNodeRef, checkConditions, action.getExecuteAsychronously());
    }

    @Override
    public void executeAction(Action action, NodeRef actionedUponNodeRef, boolean checkConditions, boolean executeAsychronously) {
        Set<String> actionChain = this.currentActionChain.get();
        if (!executeAsychronously) {
            this.executeActionImpl(action, actionedUponNodeRef, checkConditions, false, actionChain);
        } else {
            this.addPostTransactionPendingAction(action, actionedUponNodeRef, checkConditions, actionChain);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeActionImpl(Action action, NodeRef actionedUponNodeRef, boolean checkConditions, boolean executedAsynchronously, Set<String> actionChain) {
        if (logger.isDebugEnabled()) {
            StringBuilder builder = new StringBuilder("Exceute action impl action chain = ");
            if (actionChain == null) {
                builder.append("null");
            } else {
                for (String value : actionChain) {
                    builder.append(value).append(" ");
                }
            }
            logger.debug((Object)builder.toString());
            logger.debug((Object)("Current action = " + action.getId()));
        }
        String currentUserName = this.authenticationComponent.getCurrentUserName();
        if (actionChain == null || !actionChain.contains(action.getId())) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Doing executeActionImpl");
            }
            try {
                HashSet<String> origActionChain = null;
                if (actionChain == null) {
                    actionChain = new HashSet<String>();
                } else {
                    origActionChain = new HashSet<String>(actionChain);
                }
                actionChain.add(action.getId());
                this.currentActionChain.set(actionChain);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Adding " + action.getId() + " to action chain."));
                }
                try {
                    if (!checkConditions || this.evaluateAction(action, actionedUponNodeRef)) {
                        this.directActionExecution(action, actionedUponNodeRef);
                    }
                }
                finally {
                    if (origActionChain == null) {
                        this.currentActionChain.remove();
                    } else {
                        this.currentActionChain.set(origActionChain);
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"Resetting the action chain.");
                    }
                }
            }
            catch (Throwable exception) {
                Action compensatingAction;
                logger.error((Object)("An error was encountered whilst executing the action '" + action.getActionDefinitionName() + "'."), exception);
                if (executedAsynchronously && (compensatingAction = action.getCompensatingAction()) != null) {
                    ((ActionImpl)compensatingAction).setRunAsUser(currentUserName);
                    this.asynchronousActionExecutionQueue.executeAction(this, compensatingAction, actionedUponNodeRef, false, null);
                }
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                throw new ActionServiceException(ERR_FAIL, exception);
            }
        }
    }

    @Override
    public void directActionExecution(Action action, NodeRef actionedUponNodeRef) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("The action is being executed as the user: " + this.authenticationComponent.getCurrentUserName()));
        }
        ActionExecuter executer = (ActionExecuter)this.applicationContext.getBean(action.getActionDefinitionName());
        executer.execute(action, actionedUponNodeRef);
    }

    @Override
    public void executeAction(Action action, NodeRef actionedUponNodeRef) {
        this.executeAction(action, actionedUponNodeRef, true);
    }

    @Override
    public void registerActionConditionEvaluator(ActionConditionEvaluator actionConditionEvaluator) {
        ActionConditionDefinition cond = actionConditionEvaluator.getActionConditionDefintion();
        this.conditionDefinitions.put(cond.getName(), cond);
    }

    @Override
    public void registerActionExecuter(ActionExecuter actionExecuter) {
        ActionDefinition action = actionExecuter.getActionDefinition();
        this.actionDefinitions.put(action.getName(), action);
    }

    private NodeRef getActionNodeRefFromId(NodeRef nodeRef, String actionId) {
        NodeRef result = null;
        if (this.nodeService.hasAspect(nodeRef, ActionModel.ASPECT_ACTIONS)) {
            DynamicNamespacePrefixResolver namespacePrefixResolver = new DynamicNamespacePrefixResolver();
            namespacePrefixResolver.registerNamespace("sys", "http://www.alfresco.org/model/system/1.0");
            List<NodeRef> nodeRefs = this.searchService.selectNodes(this.getSavedActionFolderRef(nodeRef), "*[@sys:" + ContentModel.PROP_NODE_UUID.getLocalName() + "='" + actionId + "']", null, namespacePrefixResolver, false);
            if (nodeRefs.size() != 0) {
                result = nodeRefs.get(0);
            }
        }
        return result;
    }

    @Override
    public void saveAction(NodeRef nodeRef, Action action) {
        NodeRef actionNodeRef = this.getActionNodeRefFromId(nodeRef, action.getId());
        if (actionNodeRef == null) {
            if (!this.nodeService.hasAspect(nodeRef, ActionModel.ASPECT_ACTIONS)) {
                this.nodeService.addAspect(nodeRef, ActionModel.ASPECT_ACTIONS, null);
            }
            HashMap<QName, Serializable> props = new HashMap<QName, Serializable>(2);
            props.put(ActionModel.PROP_DEFINITION_NAME, (Serializable)((Object)action.getActionDefinitionName()));
            props.put(ContentModel.PROP_NODE_UUID, (Serializable)((Object)action.getId()));
            QName actionType = ActionModel.TYPE_ACTION;
            if (action instanceof CompositeAction) {
                actionType = ActionModel.TYPE_COMPOSITE_ACTION;
            }
            actionNodeRef = this.nodeService.createNode(this.getSavedActionFolderRef(nodeRef), ContentModel.ASSOC_CONTAINS, ASSOC_NAME_ACTIONS, actionType, props).getChildRef();
            ((ActionImpl)action).setCreator((String)((Object)this.nodeService.getProperty(actionNodeRef, ContentModel.PROP_CREATOR)));
            ((ActionImpl)action).setCreatedDate((Date)this.nodeService.getProperty(actionNodeRef, ContentModel.PROP_CREATED));
        }
        this.saveActionImpl(nodeRef, actionNodeRef, action);
    }

    @Override
    public void saveActionImpl(NodeRef owningNodeRef, NodeRef actionNodeRef, Action action) {
        ((ActionImpl)action).setOwningNodeRef(owningNodeRef);
        this.saveActionProperties(actionNodeRef, action);
        this.saveParameters(actionNodeRef, action);
        this.saveConditions(actionNodeRef, action);
        if (action instanceof CompositeAction) {
            this.saveActions(actionNodeRef, (CompositeAction)action);
        }
        ((ActionImpl)action).setModifier((String)((Object)this.nodeService.getProperty(actionNodeRef, ContentModel.PROP_MODIFIER)));
        ((ActionImpl)action).setModifiedDate((Date)this.nodeService.getProperty(actionNodeRef, ContentModel.PROP_MODIFIED));
    }

    private void saveActionProperties(NodeRef actionNodeRef, Action action) {
        Map<QName, Serializable> props = this.nodeService.getProperties(actionNodeRef);
        props.put(ActionModel.PROP_ACTION_TITLE, (Serializable)((Object)action.getTitle()));
        props.put(ActionModel.PROP_ACTION_DESCRIPTION, (Serializable)((Object)action.getDescription()));
        props.put(ActionModel.PROP_EXECUTE_ASYNCHRONOUSLY, Boolean.valueOf(action.getExecuteAsychronously()));
        this.nodeService.setProperties(actionNodeRef, props);
        Action compensatingAction = action.getCompensatingAction();
        List<ChildAssociationRef> assocs = this.nodeService.getChildAssocs(actionNodeRef, RegexQNamePattern.MATCH_ALL, ActionModel.ASSOC_COMPENSATING_ACTION);
        if (assocs.size() == 0) {
            if (compensatingAction != null) {
                HashMap<QName, Serializable> props2 = new HashMap<QName, Serializable>(2);
                props2.put(ActionModel.PROP_DEFINITION_NAME, (Serializable)((Object)compensatingAction.getActionDefinitionName()));
                props2.put(ContentModel.PROP_NODE_UUID, (Serializable)((Object)compensatingAction.getId()));
                NodeRef compensatingActionNodeRef = this.nodeService.createNode(actionNodeRef, ActionModel.ASSOC_COMPENSATING_ACTION, ActionModel.ASSOC_COMPENSATING_ACTION, ActionModel.TYPE_ACTION, props2).getChildRef();
                this.saveActionImpl(compensatingAction.getOwningNodeRef(), compensatingActionNodeRef, compensatingAction);
            }
        } else {
            ChildAssociationRef assoc = assocs.get(0);
            if (compensatingAction == null) {
                this.nodeService.removeChild(actionNodeRef, assoc.getChildRef());
            } else {
                this.saveActionImpl(compensatingAction.getOwningNodeRef(), assoc.getChildRef(), compensatingAction);
            }
        }
    }

    private void saveActions(NodeRef compositeActionNodeRef, CompositeAction compositeAction) {
        HashMap<String, Action> idToAction = new HashMap<String, Action>();
        ArrayList<String> orderedIds = new ArrayList<String>();
        for (Action action : compositeAction.getActions()) {
            idToAction.put(action.getId(), action);
            orderedIds.add(action.getId());
        }
        List<ChildAssociationRef> actionRefs = this.nodeService.getChildAssocs(compositeActionNodeRef, RegexQNamePattern.MATCH_ALL, ActionModel.ASSOC_ACTIONS);
        for (ChildAssociationRef actionRef : actionRefs) {
            NodeRef actionNodeRef = actionRef.getChildRef();
            if (!idToAction.containsKey(actionNodeRef.getId())) {
                this.nodeService.removeChild(compositeActionNodeRef, actionNodeRef);
                continue;
            }
            Action action = (Action)idToAction.get(actionNodeRef.getId());
            this.saveActionImpl(action.getOwningNodeRef(), actionNodeRef, action);
            orderedIds.remove(actionNodeRef.getId());
        }
        for (String actionId : orderedIds) {
            Action action = (Action)idToAction.get(actionId);
            HashMap<QName, Serializable> props = new HashMap<QName, Serializable>(2);
            props.put(ActionModel.PROP_DEFINITION_NAME, (Serializable)((Object)action.getActionDefinitionName()));
            props.put(ContentModel.PROP_NODE_UUID, (Serializable)((Object)action.getId()));
            NodeRef actionNodeRef = this.nodeService.createNode(compositeActionNodeRef, ActionModel.ASSOC_ACTIONS, ActionModel.ASSOC_ACTIONS, ActionModel.TYPE_ACTION, props).getChildRef();
            this.saveActionImpl(action.getOwningNodeRef(), actionNodeRef, action);
        }
    }

    private void saveConditions(NodeRef actionNodeRef, Action action) {
        HashMap<String, ActionCondition> idToCondition = new HashMap<String, ActionCondition>();
        ArrayList<String> orderedIds = new ArrayList<String>();
        for (ActionCondition actionCondition : action.getActionConditions()) {
            idToCondition.put(actionCondition.getId(), actionCondition);
            orderedIds.add(actionCondition.getId());
        }
        List<ChildAssociationRef> conditionRefs = this.nodeService.getChildAssocs(actionNodeRef, RegexQNamePattern.MATCH_ALL, ActionModel.ASSOC_CONDITIONS);
        for (ChildAssociationRef conditionRef : conditionRefs) {
            NodeRef conditionNodeRef = conditionRef.getChildRef();
            if (!idToCondition.containsKey(conditionNodeRef.getId())) {
                this.nodeService.removeChild(actionNodeRef, conditionNodeRef);
                continue;
            }
            this.saveConditionProperties(conditionNodeRef, (ActionCondition)idToCondition.get(conditionNodeRef.getId()));
            this.saveParameters(conditionNodeRef, (ParameterizedItem)idToCondition.get(conditionNodeRef.getId()));
            orderedIds.remove(conditionNodeRef.getId());
        }
        for (String nextId : orderedIds) {
            ActionCondition actionCondition = (ActionCondition)idToCondition.get(nextId);
            HashMap<QName, Serializable> props = new HashMap<QName, Serializable>(2);
            props.put(ActionModel.PROP_DEFINITION_NAME, (Serializable)((Object)actionCondition.getActionConditionDefinitionName()));
            props.put(ContentModel.PROP_NODE_UUID, (Serializable)((Object)actionCondition.getId()));
            NodeRef conditionNodeRef = this.nodeService.createNode(actionNodeRef, ActionModel.ASSOC_CONDITIONS, ActionModel.ASSOC_CONDITIONS, ActionModel.TYPE_ACTION_CONDITION, props).getChildRef();
            this.saveConditionProperties(conditionNodeRef, actionCondition);
            this.saveParameters(conditionNodeRef, actionCondition);
        }
    }

    private void saveConditionProperties(NodeRef conditionNodeRef, ActionCondition condition) {
        this.nodeService.setProperty(conditionNodeRef, ActionModel.PROP_CONDITION_INVERT, Boolean.valueOf(condition.getInvertCondition()));
    }

    private void saveParameters(NodeRef parameterizedNodeRef, ParameterizedItem item) {
        HashMap<String, Serializable> parameterMap = new HashMap<String, Serializable>();
        parameterMap.putAll(item.getParameterValues());
        List<ChildAssociationRef> parameters = this.nodeService.getChildAssocs(parameterizedNodeRef, RegexQNamePattern.MATCH_ALL, ActionModel.ASSOC_PARAMETERS);
        for (ChildAssociationRef childAssociationRef : parameters) {
            NodeRef paramNodeRef = childAssociationRef.getChildRef();
            Map<QName, Serializable> nodeRefParameterMap = this.nodeService.getProperties(paramNodeRef);
            String paramName = (String)((Object)nodeRefParameterMap.get(ActionModel.PROP_PARAMETER_NAME));
            if (!parameterMap.containsKey(paramName)) {
                this.nodeService.removeChild(parameterizedNodeRef, paramNodeRef);
                continue;
            }
            nodeRefParameterMap.put(ActionModel.PROP_PARAMETER_VALUE, (Serializable)parameterMap.get(paramName));
            this.nodeService.setProperties(paramNodeRef, nodeRefParameterMap);
            parameterMap.remove(paramName);
        }
        for (Map.Entry entry : parameterMap.entrySet()) {
            HashMap<QName, Serializable> nodeRefProperties = new HashMap<QName, Serializable>(2);
            nodeRefProperties.put(ActionModel.PROP_PARAMETER_NAME, (Serializable)entry.getKey());
            nodeRefProperties.put(ActionModel.PROP_PARAMETER_VALUE, (Serializable)entry.getValue());
            this.nodeService.createNode(parameterizedNodeRef, ActionModel.ASSOC_PARAMETERS, ActionModel.ASSOC_PARAMETERS, ActionModel.TYPE_ACTION_PARAMETER, nodeRefProperties);
        }
    }

    @Override
    public List<Action> getActions(NodeRef nodeRef) {
        ArrayList<Action> result = new ArrayList<Action>();
        if (this.nodeService.exists(nodeRef) && this.nodeService.hasAspect(nodeRef, ActionModel.ASPECT_ACTIONS)) {
            List<ChildAssociationRef> actions = this.nodeService.getChildAssocs(this.getSavedActionFolderRef(nodeRef), RegexQNamePattern.MATCH_ALL, ASSOC_NAME_ACTIONS);
            for (ChildAssociationRef action : actions) {
                NodeRef actionNodeRef = action.getChildRef();
                result.add(this.createAction(nodeRef, actionNodeRef));
            }
        }
        return result;
    }

    private Action createAction(NodeRef owningNodeRef, NodeRef actionNodeRef) {
        ActionImpl result = null;
        Map<QName, Serializable> properties = this.nodeService.getProperties(actionNodeRef);
        QName actionType = this.nodeService.getType(actionNodeRef);
        if (ActionModel.TYPE_COMPOSITE_ACTION.equals(actionType)) {
            result = new CompositeActionImpl(actionNodeRef.getId(), owningNodeRef);
            this.populateCompositeAction(actionNodeRef, (CompositeAction)((Object)result));
        } else {
            result = new ActionImpl(actionNodeRef.getId(), (String)((Object)properties.get(ActionModel.PROP_DEFINITION_NAME)), owningNodeRef);
            this.populateAction(actionNodeRef, result);
        }
        return result;
    }

    private void populateAction(NodeRef actionNodeRef, Action action) {
        this.populateActionProperties(actionNodeRef, action);
        this.populateParameters(actionNodeRef, action);
        List<ChildAssociationRef> conditions = this.nodeService.getChildAssocs(actionNodeRef, RegexQNamePattern.MATCH_ALL, ActionModel.ASSOC_CONDITIONS);
        for (ChildAssociationRef condition : conditions) {
            NodeRef conditionNodeRef = condition.getChildRef();
            action.addActionCondition(this.createActionCondition(conditionNodeRef));
        }
    }

    private void populateActionProperties(NodeRef actionNodeRef, Action action) {
        Map<QName, Serializable> props = this.nodeService.getProperties(actionNodeRef);
        action.setTitle((String)((Object)props.get(ActionModel.PROP_ACTION_TITLE)));
        action.setDescription((String)((Object)props.get(ActionModel.PROP_ACTION_DESCRIPTION)));
        boolean value = false;
        Boolean executeAsynchronously = (Boolean)props.get(ActionModel.PROP_EXECUTE_ASYNCHRONOUSLY);
        if (executeAsynchronously != null) {
            value = executeAsynchronously;
        }
        action.setExecuteAsynchronously(value);
        ((ActionImpl)action).setCreator((String)((Object)props.get(ContentModel.PROP_CREATOR)));
        ((ActionImpl)action).setCreatedDate((Date)props.get(ContentModel.PROP_CREATED));
        ((ActionImpl)action).setModifier((String)((Object)props.get(ContentModel.PROP_MODIFIER)));
        ((ActionImpl)action).setModifiedDate((Date)props.get(ContentModel.PROP_MODIFIED));
        List<ChildAssociationRef> assocs = this.nodeService.getChildAssocs(actionNodeRef, RegexQNamePattern.MATCH_ALL, ActionModel.ASSOC_COMPENSATING_ACTION);
        if (assocs.size() != 0) {
            Action compensatingAction = this.createAction(action.getOwningNodeRef(), assocs.get(0).getChildRef());
            action.setCompensatingAction(compensatingAction);
        }
    }

    private void populateParameters(NodeRef parameterizedItemNodeRef, ParameterizedItem parameterizedItem) {
        List<ChildAssociationRef> parameters = this.nodeService.getChildAssocs(parameterizedItemNodeRef, RegexQNamePattern.MATCH_ALL, ActionModel.ASSOC_PARAMETERS);
        for (ChildAssociationRef parameter : parameters) {
            NodeRef parameterNodeRef = parameter.getChildRef();
            Map<QName, Serializable> properties = this.nodeService.getProperties(parameterNodeRef);
            parameterizedItem.setParameterValue((String)((Object)properties.get(ActionModel.PROP_PARAMETER_NAME)), properties.get(ActionModel.PROP_PARAMETER_VALUE));
        }
    }

    private ActionCondition createActionCondition(NodeRef conditionNodeRef) {
        Map<QName, Serializable> properties = this.nodeService.getProperties(conditionNodeRef);
        ActionConditionImpl condition = new ActionConditionImpl(conditionNodeRef.getId(), (String)((Object)properties.get(ActionModel.PROP_DEFINITION_NAME)));
        boolean value = false;
        Boolean invert = (Boolean)this.nodeService.getProperty(conditionNodeRef, ActionModel.PROP_CONDITION_INVERT);
        if (invert != null) {
            value = invert;
        }
        condition.setInvertCondition(value);
        this.populateParameters(conditionNodeRef, condition);
        return condition;
    }

    @Override
    public void populateCompositeAction(NodeRef compositeNodeRef, CompositeAction compositeAction) {
        this.populateAction(compositeNodeRef, compositeAction);
        List<ChildAssociationRef> actions = this.nodeService.getChildAssocs(compositeNodeRef, RegexQNamePattern.MATCH_ALL, ActionModel.ASSOC_ACTIONS);
        for (ChildAssociationRef action : actions) {
            NodeRef actionNodeRef = action.getChildRef();
            compositeAction.addAction(this.createAction(compositeAction.getOwningNodeRef(), actionNodeRef));
        }
    }

    @Override
    public Action getAction(NodeRef nodeRef, String actionId) {
        NodeRef actionNodeRef;
        Action result = null;
        if (this.nodeService.exists(nodeRef) && this.nodeService.hasAspect(nodeRef, ActionModel.ASPECT_ACTIONS) && (actionNodeRef = this.getActionNodeRefFromId(nodeRef, actionId)) != null) {
            result = this.createAction(nodeRef, actionNodeRef);
        }
        return result;
    }

    @Override
    public void removeAction(NodeRef nodeRef, Action action) {
        NodeRef actionNodeRef;
        if (this.nodeService.exists(nodeRef) && this.nodeService.hasAspect(nodeRef, ActionModel.ASPECT_ACTIONS) && (actionNodeRef = this.getActionNodeRefFromId(nodeRef, action.getId())) != null) {
            this.nodeService.removeChild(this.getSavedActionFolderRef(nodeRef), actionNodeRef);
        }
    }

    @Override
    public void removeAllActions(NodeRef nodeRef) {
        if (this.nodeService.exists(nodeRef) && this.nodeService.hasAspect(nodeRef, ActionModel.ASPECT_ACTIONS)) {
            ArrayList<ChildAssociationRef> actions = new ArrayList<ChildAssociationRef>(this.nodeService.getChildAssocs(this.getSavedActionFolderRef(nodeRef), RegexQNamePattern.MATCH_ALL, ASSOC_NAME_ACTIONS));
            for (ChildAssociationRef action : actions) {
                this.nodeService.removeChild(this.getSavedActionFolderRef(nodeRef), action.getChildRef());
            }
        }
    }

    private void addPostTransactionPendingAction(Action action, NodeRef actionedUponNodeRef, boolean checkConditions, Set<String> actionChain) {
        if (logger.isDebugEnabled()) {
            StringBuilder builder = new StringBuilder("addPostTransactionPendingAction action chain = ");
            if (actionChain == null) {
                builder.append("null");
            } else {
                for (String value : actionChain) {
                    builder.append(value).append(" ");
                }
            }
            logger.debug((Object)builder.toString());
            logger.debug((Object)("Current action = " + action.getId()));
        }
        if (actionChain == null || !actionChain.contains(action.getId())) {
            PendingAction pendingAction;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Doing addPostTransactionPendingAction");
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("The current user is: " + this.authenticationComponent.getCurrentUserName()));
            }
            ((ActionImpl)action).setRunAsUser(this.authenticationComponent.getCurrentUserName());
            AlfrescoTransactionSupport.bindListener(this.transactionListener);
            ArrayList<PendingAction> pendingActions = (ArrayList<PendingAction>)AlfrescoTransactionSupport.getResource(POST_TRANSACTION_PENDING_ACTIONS);
            if (pendingActions == null) {
                pendingActions = new ArrayList<PendingAction>();
                AlfrescoTransactionSupport.bindResource(POST_TRANSACTION_PENDING_ACTIONS, pendingActions);
            }
            if (!pendingActions.contains(pendingAction = new PendingAction(action, actionedUponNodeRef, checkConditions, actionChain))) {
                pendingActions.add(pendingAction);
            }
        }
    }

    @Override
    public List<PendingAction> getPostTransactionPendingActions() {
        return (List)AlfrescoTransactionSupport.getResource(POST_TRANSACTION_PENDING_ACTIONS);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class PendingAction {
        private Action action;
        private NodeRef actionedUponNodeRef;
        private boolean checkConditions;
        private Set<String> actionChain;

        public PendingAction(Action action, NodeRef actionedUponNodeRef, boolean checkConditions, Set<String> actionChain) {
            this.action = action;
            this.actionedUponNodeRef = actionedUponNodeRef;
            this.checkConditions = checkConditions;
            this.actionChain = actionChain;
        }

        public Action getAction() {
            return this.action;
        }

        public NodeRef getActionedUponNodeRef() {
            return this.actionedUponNodeRef;
        }

        public boolean getCheckConditions() {
            return this.checkConditions;
        }

        public Set<String> getActionChain() {
            return this.actionChain;
        }

        public int hashCode() {
            int hashCode = 37 * this.actionedUponNodeRef.hashCode();
            return hashCode += 37 * this.action.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof PendingAction) {
                PendingAction that = (PendingAction)obj;
                return this.action.equals(that.action) && this.actionedUponNodeRef.equals(that.actionedUponNodeRef);
            }
            return false;
        }
    }
}

