/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.action;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import junit.framework.Assert;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.action.evaluator.compare.ComparePropertyValueOperation;
import org.alfresco.repo.transaction.TransactionUtil;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ActionCondition;
import org.alfresco.service.cmr.action.ActionConditionDefinition;
import org.alfresco.service.cmr.action.ActionDefinition;
import org.alfresco.service.cmr.action.CompositeAction;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.BaseAlfrescoSpringTest;

public class ActionServiceImplTest
extends BaseAlfrescoSpringTest {
    private static final String BAD_NAME = "badName";
    private NodeRef nodeRef;
    private NodeRef folder;

    protected void onSetUpInTransaction() throws Exception {
        super.onSetUpInTransaction();
        this.nodeRef = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName("{test}testnode"), ContentModel.TYPE_CONTENT).getChildRef();
        this.nodeService.setProperty(this.nodeRef, ContentModel.PROP_CONTENT, new ContentData(null, "text/plain", 0L, null));
        this.folder = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName("{test}testFolder"), ContentModel.TYPE_FOLDER).getChildRef();
    }

    public void testGetActionDefinition() {
        ActionDefinition action = this.actionService.getActionDefinition("add-features");
        ActionServiceImplTest.assertNotNull((Object)action);
        ActionServiceImplTest.assertEquals((String)"add-features", (String)action.getName());
        ActionConditionDefinition nullCondition = this.actionService.getActionConditionDefinition(BAD_NAME);
        ActionServiceImplTest.assertNull((Object)nullCondition);
    }

    public void testGetActionDefinitions() {
        List<ActionDefinition> defintions = this.actionService.getActionDefinitions();
        ActionServiceImplTest.assertNotNull(defintions);
        ActionServiceImplTest.assertFalse((boolean)defintions.isEmpty());
        int totalCount = defintions.size();
        for (ActionDefinition definition : defintions) {
            System.out.println(definition.getTitle());
        }
        List<ActionDefinition> definitions = this.actionService.getActionDefinitions(this.folder);
        ActionServiceImplTest.assertNotNull(definitions);
        ActionServiceImplTest.assertTrue((totalCount > definitions.size() ? 1 : 0) != 0);
    }

    public void testGetActionConditionDefinition() {
        ActionConditionDefinition condition = this.actionService.getActionConditionDefinition("no-condition");
        ActionServiceImplTest.assertNotNull((Object)condition);
        ActionServiceImplTest.assertEquals((String)"no-condition", (String)condition.getName());
        ActionConditionDefinition nullCondition = this.actionService.getActionConditionDefinition(BAD_NAME);
        ActionServiceImplTest.assertNull((Object)nullCondition);
    }

    public void testGetActionConditionDefinitions() {
        List<ActionConditionDefinition> defintions = this.actionService.getActionConditionDefinitions();
        ActionServiceImplTest.assertNotNull(defintions);
        ActionServiceImplTest.assertFalse((boolean)defintions.isEmpty());
        for (ActionConditionDefinition definition : defintions) {
            System.out.println(definition.getTitle());
        }
    }

    public void testCreateActionCondition() {
        ActionCondition condition = this.actionService.createActionCondition("no-condition");
        ActionServiceImplTest.assertNotNull((Object)condition);
        ActionServiceImplTest.assertEquals((String)"no-condition", (String)condition.getActionConditionDefinitionName());
    }

    public void testCreateAction() {
        Action action = this.actionService.createAction("add-features");
        ActionServiceImplTest.assertNotNull((Object)action);
        ActionServiceImplTest.assertEquals((String)"add-features", (String)action.getActionDefinitionName());
    }

    public void testCreateCompositeAction() {
        CompositeAction action = this.actionService.createCompositeAction();
        ActionServiceImplTest.assertNotNull((Object)action);
        ActionServiceImplTest.assertEquals((String)"composite-action", (String)action.getActionDefinitionName());
    }

    public void testEvaluateAction() {
        Action action = this.actionService.createAction("add-features");
        ActionServiceImplTest.assertTrue((boolean)this.actionService.evaluateAction(action, this.nodeRef));
        ActionCondition condition = this.actionService.createActionCondition("compare-property-value");
        condition.setParameterValue("value", (Serializable)((Object)"*.doc"));
        action.addActionCondition(condition);
        ActionServiceImplTest.assertFalse((boolean)this.actionService.evaluateAction(action, this.nodeRef));
        this.nodeService.setProperty(this.nodeRef, ContentModel.PROP_NAME, (Serializable)((Object)"myDocument.doc"));
        ActionServiceImplTest.assertTrue((boolean)this.actionService.evaluateAction(action, this.nodeRef));
        ActionCondition condition2 = this.actionService.createActionCondition("compare-property-value");
        condition2.setParameterValue("value", (Serializable)((Object)"my"));
        action.addActionCondition(condition2);
        ActionServiceImplTest.assertTrue((boolean)this.actionService.evaluateAction(action, this.nodeRef));
        this.nodeService.setProperty(this.nodeRef, ContentModel.PROP_NAME, (Serializable)((Object)"document.doc"));
        ActionServiceImplTest.assertFalse((boolean)this.actionService.evaluateAction(action, this.nodeRef));
    }

    public void testEvaluateActionCondition() {
        ActionCondition condition = this.actionService.createActionCondition("compare-property-value");
        condition.setParameterValue("value", (Serializable)((Object)"*.doc"));
        ActionServiceImplTest.assertFalse((boolean)this.actionService.evaluateActionCondition(condition, this.nodeRef));
        this.nodeService.setProperty(this.nodeRef, ContentModel.PROP_NAME, (Serializable)((Object)"myDocument.doc"));
        ActionServiceImplTest.assertTrue((boolean)this.actionService.evaluateActionCondition(condition, this.nodeRef));
        condition.setInvertCondition(true);
        ActionServiceImplTest.assertFalse((boolean)this.actionService.evaluateActionCondition(condition, this.nodeRef));
    }

    public void testExecuteAction() {
        ActionServiceImplTest.assertFalse((boolean)this.nodeService.hasAspect(this.nodeRef, ContentModel.ASPECT_VERSIONABLE));
        Action action = this.actionService.createAction("add-features");
        action.setParameterValue("aspect-name", ContentModel.ASPECT_VERSIONABLE);
        this.actionService.executeAction(action, this.nodeRef);
        ActionServiceImplTest.assertTrue((boolean)this.nodeService.hasAspect(this.nodeRef, ContentModel.ASPECT_VERSIONABLE));
        this.nodeService.removeAspect(this.nodeRef, ContentModel.ASPECT_VERSIONABLE);
        ActionServiceImplTest.assertFalse((boolean)this.nodeService.hasAspect(this.nodeRef, ContentModel.ASPECT_VERSIONABLE));
        ActionCondition condition = this.actionService.createActionCondition("compare-property-value");
        condition.setParameterValue("value", (Serializable)((Object)"*.doc"));
        action.addActionCondition(condition);
        this.actionService.executeAction(action, this.nodeRef);
        ActionServiceImplTest.assertFalse((boolean)this.nodeService.hasAspect(this.nodeRef, ContentModel.ASPECT_VERSIONABLE));
        this.actionService.executeAction(action, this.nodeRef, true);
        ActionServiceImplTest.assertFalse((boolean)this.nodeService.hasAspect(this.nodeRef, ContentModel.ASPECT_VERSIONABLE));
        this.actionService.executeAction(action, this.nodeRef, false);
        ActionServiceImplTest.assertTrue((boolean)this.nodeService.hasAspect(this.nodeRef, ContentModel.ASPECT_VERSIONABLE));
        this.nodeService.removeAspect(this.nodeRef, ContentModel.ASPECT_VERSIONABLE);
        ActionServiceImplTest.assertFalse((boolean)this.nodeService.hasAspect(this.nodeRef, ContentModel.ASPECT_VERSIONABLE));
        this.nodeService.setProperty(this.nodeRef, ContentModel.PROP_NAME, (Serializable)((Object)"myDocument.doc"));
        this.actionService.executeAction(action, this.nodeRef);
        ActionServiceImplTest.assertTrue((boolean)this.nodeService.hasAspect(this.nodeRef, ContentModel.ASPECT_VERSIONABLE));
        this.nodeService.removeAspect(this.nodeRef, ContentModel.ASPECT_VERSIONABLE);
        ActionServiceImplTest.assertFalse((boolean)this.nodeService.hasAspect(this.nodeRef, ContentModel.ASPECT_VERSIONABLE));
        this.nodeService.removeAspect(this.nodeRef, ContentModel.ASPECT_VERSIONABLE);
        ActionServiceImplTest.assertFalse((boolean)this.nodeService.hasAspect(this.nodeRef, ContentModel.ASPECT_VERSIONABLE));
        Action action1 = this.actionService.createAction("add-features");
        action1.setParameterValue("aspect-name", ContentModel.ASPECT_LOCKABLE);
        Action action2 = this.actionService.createAction("add-features");
        action2.setParameterValue("aspect-name", ContentModel.ASPECT_VERSIONABLE);
        CompositeAction compAction = this.actionService.createCompositeAction();
        compAction.setTitle("title");
        compAction.setDescription("description");
        compAction.addAction(action1);
        compAction.addAction(action2);
        this.actionService.executeAction(compAction, this.nodeRef);
        ActionServiceImplTest.assertTrue((boolean)this.nodeService.hasAspect(this.nodeRef, ContentModel.ASPECT_LOCKABLE));
        ActionServiceImplTest.assertTrue((boolean)this.nodeService.hasAspect(this.nodeRef, ContentModel.ASPECT_VERSIONABLE));
    }

    public void testGetAndGetAllWithNoActions() {
        ActionServiceImplTest.assertNull((Object)this.actionService.getAction(this.nodeRef, "add-features"));
        List<Action> actions = this.actionService.getActions(this.nodeRef);
        ActionServiceImplTest.assertNotNull(actions);
        ActionServiceImplTest.assertEquals((int)0, (int)actions.size());
    }

    public void testSaveActionNoCondition() {
        Action action = this.actionService.createAction("add-features");
        String actionId = action.getId();
        action.setParameterValue("aspect-name", ContentModel.ASPECT_VERSIONABLE);
        action.setTitle("title");
        action.setDescription("description");
        action.setExecuteAsynchronously(true);
        this.actionService.saveAction(this.nodeRef, action);
        Action savedAction = this.actionService.getAction(this.nodeRef, actionId);
        ActionServiceImplTest.assertEquals((String)action.getId(), (String)savedAction.getId());
        ActionServiceImplTest.assertEquals((String)action.getActionDefinitionName(), (String)savedAction.getActionDefinitionName());
        ActionServiceImplTest.assertEquals((String)"title", (String)savedAction.getTitle());
        ActionServiceImplTest.assertEquals((String)"description", (String)savedAction.getDescription());
        ActionServiceImplTest.assertTrue((boolean)savedAction.getExecuteAsychronously());
        ActionServiceImplTest.assertNull((Object)savedAction.getCompensatingAction());
        ActionServiceImplTest.assertEquals((int)1, (int)savedAction.getParameterValues().size());
        ActionServiceImplTest.assertEquals((Object)ContentModel.ASPECT_VERSIONABLE, (Object)savedAction.getParameterValue("aspect-name"));
        ActionServiceImplTest.assertNotNull(savedAction.getActionConditions());
        ActionServiceImplTest.assertEquals((int)0, (int)savedAction.getActionConditions().size());
        HashMap<QName, String> properties = new HashMap<QName, String>(1);
        properties.put(ContentModel.PROP_NAME, "testName");
        action.setParameterValue("aspect_properties", properties);
        action.setParameterValue("aspect-name", ContentModel.ASPECT_AUDITABLE);
        Action compensatingAction = this.actionService.createAction("add-features");
        compensatingAction.setParameterValue("aspect-name", ContentModel.ASPECT_VERSIONABLE);
        action.setCompensatingAction(compensatingAction);
        this.actionService.saveAction(this.nodeRef, action);
        Action savedAction2 = this.actionService.getAction(this.nodeRef, actionId);
        ActionServiceImplTest.assertEquals((int)2, (int)savedAction2.getParameterValues().size());
        ActionServiceImplTest.assertEquals((Object)ContentModel.ASPECT_AUDITABLE, (Object)savedAction2.getParameterValue("aspect-name"));
        Map temp = (Map)((Object)savedAction2.getParameterValue("aspect_properties"));
        ActionServiceImplTest.assertNotNull((Object)temp);
        ActionServiceImplTest.assertEquals((int)1, (int)temp.size());
        ActionServiceImplTest.assertEquals((Object)"testName", temp.get(ContentModel.PROP_NAME));
        Action savedCompensatingAction = savedAction2.getCompensatingAction();
        ActionServiceImplTest.assertNotNull((Object)savedCompensatingAction);
        ActionServiceImplTest.assertEquals((Object)compensatingAction, (Object)savedCompensatingAction);
        ActionServiceImplTest.assertEquals((String)"add-features", (String)savedCompensatingAction.getActionDefinitionName());
        ActionServiceImplTest.assertEquals((Object)ContentModel.ASPECT_VERSIONABLE, (Object)savedCompensatingAction.getParameterValue("aspect-name"));
        compensatingAction.setParameterValue("aspect-name", ContentModel.ASPECT_CLASSIFIABLE);
        this.actionService.saveAction(this.nodeRef, action);
        Action savedAction3 = this.actionService.getAction(this.nodeRef, actionId);
        Action savedCompensatingAction2 = savedAction3.getCompensatingAction();
        ActionServiceImplTest.assertNotNull((Object)savedCompensatingAction2);
        ActionServiceImplTest.assertEquals((Object)compensatingAction, (Object)savedCompensatingAction2);
        ActionServiceImplTest.assertEquals((String)"add-features", (String)savedCompensatingAction2.getActionDefinitionName());
        ActionServiceImplTest.assertEquals((Object)ContentModel.ASPECT_CLASSIFIABLE, (Object)savedCompensatingAction2.getParameterValue("aspect-name"));
        action.setCompensatingAction(null);
        this.actionService.saveAction(this.nodeRef, action);
        Action savedAction4 = this.actionService.getAction(this.nodeRef, actionId);
        ActionServiceImplTest.assertNull((Object)savedAction4.getCompensatingAction());
    }

    public void testOwningNodeRef() {
        Action action = this.actionService.createAction("add-features");
        String actionId = action.getId();
        action.setParameterValue("aspect-name", ContentModel.ASPECT_VERSIONABLE);
        action.setTitle("title");
        action.setDescription("description");
        action.setExecuteAsynchronously(true);
        ActionServiceImplTest.assertNull((Object)action.getOwningNodeRef());
        this.actionService.saveAction(this.nodeRef, action);
        ActionServiceImplTest.assertEquals((Object)this.nodeRef, (Object)action.getOwningNodeRef());
        Action savedAction = this.actionService.getAction(this.nodeRef, actionId);
        ActionServiceImplTest.assertEquals((Object)this.nodeRef, (Object)savedAction.getOwningNodeRef());
    }

    public void testSaveActionWithConditions() {
        Action action = this.actionService.createAction("add-features");
        String actionId = action.getId();
        action.setParameterValue("aspect-name", ContentModel.ASPECT_VERSIONABLE);
        HashMap<QName, String> properties = new HashMap<QName, String>(1);
        properties.put(ContentModel.PROP_NAME, "testName");
        action.setParameterValue("aspect_properties", properties);
        ActionCondition actionCondition = this.actionService.createActionCondition("no-condition");
        actionCondition.setInvertCondition(true);
        ActionCondition actionCondition2 = this.actionService.createActionCondition("compare-property-value");
        actionCondition2.setParameterValue("value", (Serializable)((Object)"*.doc"));
        action.addActionCondition(actionCondition);
        action.addActionCondition(actionCondition2);
        this.actionService.saveAction(this.nodeRef, action);
        Action savedAction = this.actionService.getAction(this.nodeRef, actionId);
        ActionServiceImplTest.assertEquals((String)action.getId(), (String)savedAction.getId());
        ActionServiceImplTest.assertEquals((String)action.getActionDefinitionName(), (String)savedAction.getActionDefinitionName());
        ActionServiceImplTest.assertEquals((int)action.getParameterValues().size(), (int)savedAction.getParameterValues().size());
        ActionServiceImplTest.assertEquals((Object)ContentModel.ASPECT_VERSIONABLE, (Object)savedAction.getParameterValue("aspect-name"));
        Map temp = (Map)((Object)savedAction.getParameterValue("aspect_properties"));
        ActionServiceImplTest.assertNotNull((Object)temp);
        ActionServiceImplTest.assertEquals((int)1, (int)temp.size());
        ActionServiceImplTest.assertEquals((Object)"testName", temp.get(ContentModel.PROP_NAME));
        ActionServiceImplTest.assertNotNull(savedAction.getActionConditions());
        ActionServiceImplTest.assertEquals((int)2, (int)savedAction.getActionConditions().size());
        for (ActionCondition savedCondition : savedAction.getActionConditions()) {
            if (savedCondition.getActionConditionDefinitionName().equals("no-condition")) {
                ActionServiceImplTest.assertEquals((int)0, (int)savedCondition.getParameterValues().size());
                ActionServiceImplTest.assertTrue((boolean)savedCondition.getInvertCondition());
                continue;
            }
            if (savedCondition.getActionConditionDefinitionName().equals("compare-property-value")) {
                ActionServiceImplTest.assertEquals((int)1, (int)savedCondition.getParameterValues().size());
                ActionServiceImplTest.assertEquals((Object)"*.doc", (Object)savedCondition.getParameterValue("value"));
                ActionServiceImplTest.assertFalse((boolean)savedCondition.getInvertCondition());
                continue;
            }
            ActionServiceImplTest.fail((String)"There is a condition here that we are not expecting.");
        }
        ActionCondition actionCondition3 = this.actionService.createActionCondition("in-category");
        actionCondition3.setParameterValue("category-aspect", ContentModel.ASPECT_OWNABLE);
        action.addActionCondition(actionCondition3);
        action.removeActionCondition(actionCondition);
        actionCondition2.setParameterValue("value", (Serializable)((Object)"*.exe"));
        actionCondition2.setParameterValue("operation", (Serializable)((Object)ComparePropertyValueOperation.EQUALS));
        this.actionService.saveAction(this.nodeRef, action);
        Action savedAction2 = this.actionService.getAction(this.nodeRef, actionId);
        ActionServiceImplTest.assertNotNull(savedAction2.getActionConditions());
        ActionServiceImplTest.assertEquals((int)2, (int)savedAction2.getActionConditions().size());
        for (ActionCondition savedCondition : savedAction2.getActionConditions()) {
            if (savedCondition.getActionConditionDefinitionName().equals("in-category")) {
                ActionServiceImplTest.assertEquals((int)1, (int)savedCondition.getParameterValues().size());
                ActionServiceImplTest.assertEquals((Object)ContentModel.ASPECT_OWNABLE, (Object)savedCondition.getParameterValue("category-aspect"));
                continue;
            }
            if (savedCondition.getActionConditionDefinitionName().equals("compare-property-value")) {
                ActionServiceImplTest.assertEquals((int)2, (int)savedCondition.getParameterValues().size());
                ActionServiceImplTest.assertEquals((Object)"*.exe", (Object)savedCondition.getParameterValue("value"));
                ActionServiceImplTest.assertEquals((Object)((Object)ComparePropertyValueOperation.EQUALS), (Object)savedCondition.getParameterValue("operation"));
                continue;
            }
            ActionServiceImplTest.fail((String)"There is a condition here that we are not expecting.");
        }
    }

    public void testSaveCompositeAction() {
        Action action1 = this.actionService.createAction("add-features");
        Action action2 = this.actionService.createAction("check-in");
        CompositeAction compositeAction = this.actionService.createCompositeAction();
        String actionId = compositeAction.getId();
        compositeAction.addAction(action1);
        compositeAction.addAction(action2);
        this.actionService.saveAction(this.nodeRef, compositeAction);
        ActionServiceImplTest.assertEquals((int)1, (int)this.actionService.getActions(this.nodeRef).size());
        CompositeAction savedCompositeAction = (CompositeAction)this.actionService.getAction(this.nodeRef, actionId);
        ActionServiceImplTest.assertEquals((int)2, (int)savedCompositeAction.getActions().size());
        for (Action action : savedCompositeAction.getActions()) {
            if (action.getActionDefinitionName().equals("add-features")) {
                ActionServiceImplTest.assertEquals((Object)action, (Object)action1);
                continue;
            }
            if (action.getActionDefinitionName().equals("check-in")) {
                ActionServiceImplTest.assertEquals((Object)action, (Object)action2);
                continue;
            }
            ActionServiceImplTest.fail((String)"We have an action here we are not expecting.");
        }
        compositeAction.removeAction(action1);
        Action action3 = this.actionService.createAction("check-out");
        compositeAction.addAction(action3);
        action2.setParameterValue("description", (Serializable)((Object)"description"));
        this.actionService.saveAction(this.nodeRef, compositeAction);
        ActionServiceImplTest.assertEquals((int)1, (int)this.actionService.getActions(this.nodeRef).size());
        CompositeAction savedCompositeAction2 = (CompositeAction)this.actionService.getAction(this.nodeRef, actionId);
        ActionServiceImplTest.assertEquals((int)2, (int)savedCompositeAction2.getActions().size());
        for (Action action : savedCompositeAction2.getActions()) {
            if (action.getActionDefinitionName().equals("check-out")) {
                ActionServiceImplTest.assertEquals((Object)action, (Object)action3);
                continue;
            }
            if (action.getActionDefinitionName().equals("check-in")) {
                ActionServiceImplTest.assertEquals((Object)action, (Object)action2);
                ActionServiceImplTest.assertEquals((Object)"description", (Object)action2.getParameterValue("description"));
                continue;
            }
            ActionServiceImplTest.fail((String)"We have an action here we are not expecting.");
        }
    }

    public void testRemove() {
        ActionServiceImplTest.assertEquals((int)0, (int)this.actionService.getActions(this.nodeRef).size());
        Action action1 = this.actionService.createAction("add-features");
        this.actionService.saveAction(this.nodeRef, action1);
        Action action2 = this.actionService.createAction("check-in");
        this.actionService.saveAction(this.nodeRef, action2);
        ActionServiceImplTest.assertEquals((int)2, (int)this.actionService.getActions(this.nodeRef).size());
        this.actionService.removeAction(this.nodeRef, action1);
        ActionServiceImplTest.assertEquals((int)1, (int)this.actionService.getActions(this.nodeRef).size());
        this.actionService.removeAllActions(this.nodeRef);
        ActionServiceImplTest.assertEquals((int)0, (int)this.actionService.getActions(this.nodeRef).size());
    }

    public void testConditionOrder() {
        Action action = this.actionService.createAction("add-features");
        String actionId = action.getId();
        ActionCondition condition1 = this.actionService.createActionCondition("no-condition");
        ActionCondition condition2 = this.actionService.createActionCondition("no-condition");
        action.addActionCondition(condition1);
        action.addActionCondition(condition2);
        this.actionService.saveAction(this.nodeRef, action);
        Action savedAction = this.actionService.getAction(this.nodeRef, actionId);
        ActionServiceImplTest.assertNotNull((Object)savedAction);
        ActionServiceImplTest.assertEquals((Object)condition1, (Object)savedAction.getActionCondition(0));
        ActionServiceImplTest.assertEquals((Object)condition2, (Object)savedAction.getActionCondition(1));
        ActionCondition condition3 = this.actionService.createActionCondition("no-condition");
        ActionCondition condition4 = this.actionService.createActionCondition("no-condition");
        savedAction.removeActionCondition(condition1);
        savedAction.addActionCondition(condition3);
        savedAction.addActionCondition(condition4);
        this.actionService.saveAction(this.nodeRef, savedAction);
        Action savedAction2 = this.actionService.getAction(this.nodeRef, actionId);
        ActionServiceImplTest.assertNotNull((Object)savedAction2);
        ActionServiceImplTest.assertEquals((Object)condition2, (Object)savedAction2.getActionCondition(0));
        ActionServiceImplTest.assertEquals((Object)condition3, (Object)savedAction2.getActionCondition(1));
        ActionServiceImplTest.assertEquals((Object)condition4, (Object)savedAction2.getActionCondition(2));
    }

    public void testActionOrder() {
        CompositeAction action = this.actionService.createCompositeAction();
        String actionId = action.getId();
        Action action1 = this.actionService.createAction("add-features");
        Action action2 = this.actionService.createAction("add-features");
        action.addAction(action1);
        action.addAction(action2);
        this.actionService.saveAction(this.nodeRef, action);
        CompositeAction savedAction = (CompositeAction)this.actionService.getAction(this.nodeRef, actionId);
        ActionServiceImplTest.assertNotNull((Object)savedAction);
        ActionServiceImplTest.assertEquals((Object)action1, (Object)savedAction.getAction(0));
        ActionServiceImplTest.assertEquals((Object)action2, (Object)savedAction.getAction(1));
        Action action3 = this.actionService.createAction("add-features");
        Action action4 = this.actionService.createAction("add-features");
        savedAction.removeAction(action1);
        savedAction.addAction(action3);
        savedAction.addAction(action4);
        this.actionService.saveAction(this.nodeRef, savedAction);
        CompositeAction savedAction2 = (CompositeAction)this.actionService.getAction(this.nodeRef, actionId);
        ActionServiceImplTest.assertNotNull((Object)savedAction2);
        ActionServiceImplTest.assertEquals((Object)action2, (Object)savedAction2.getAction(0));
        ActionServiceImplTest.assertEquals((Object)action3, (Object)savedAction2.getAction(1));
        ActionServiceImplTest.assertEquals((Object)action4, (Object)savedAction2.getAction(2));
    }

    public void testAsyncExecuteAction() {
        ActionServiceImplTest.assertFalse((boolean)this.nodeService.hasAspect(this.nodeRef, ContentModel.ASPECT_VERSIONABLE));
        Action action = this.actionService.createAction("add-features");
        action.setParameterValue("aspect-name", ContentModel.ASPECT_VERSIONABLE);
        action.setExecuteAsynchronously(true);
        this.actionService.executeAction(action, this.nodeRef);
        this.setComplete();
        this.endTransaction();
        final NodeService finalNodeService = this.nodeService;
        final NodeRef finalNodeRef = this.nodeRef;
        ActionServiceImplTest.postAsyncActionTest(this.transactionService, 1000L, 10, new AsyncTest(){

            public boolean executeTest() {
                return finalNodeService.hasAspect(finalNodeRef, ContentModel.ASPECT_VERSIONABLE);
            }
        });
    }

    public void testAsyncCompositeActionExecute() {
        Action action1 = this.actionService.createAction("add-features");
        action1.setParameterValue("aspect-name", ContentModel.ASPECT_LOCKABLE);
        Action action2 = this.actionService.createAction("add-features");
        action2.setParameterValue("aspect-name", ContentModel.ASPECT_VERSIONABLE);
        CompositeAction compAction = this.actionService.createCompositeAction();
        compAction.setTitle("title");
        compAction.setDescription("description");
        compAction.addAction(action1);
        compAction.addAction(action2);
        compAction.setExecuteAsynchronously(true);
        this.actionService.executeAction(compAction, this.nodeRef);
        this.setComplete();
        this.endTransaction();
        final NodeService finalNodeService = this.nodeService;
        final NodeRef finalNodeRef = this.nodeRef;
        ActionServiceImplTest.postAsyncActionTest(this.transactionService, 1000L, 10, new AsyncTest(){

            public boolean executeTest() {
                return finalNodeService.hasAspect(finalNodeRef, ContentModel.ASPECT_VERSIONABLE) && finalNodeService.hasAspect(finalNodeRef, ContentModel.ASPECT_LOCKABLE);
            }
        });
    }

    public void xtestAsyncLoadTest() {
        Action action = this.actionService.createAction("add-features");
        action.setParameterValue("aspect-name", ContentModel.ASPECT_VERSIONABLE);
        action.setExecuteAsynchronously(true);
        for (int i = 0; i < 1000; ++i) {
            this.actionService.executeAction(action, this.nodeRef);
        }
        this.setComplete();
        this.endTransaction();
    }

    public static void postAsyncActionTest(TransactionService transactionService, long sleepTime, int maxTries, final AsyncTest test) {
        try {
            int tries = 0;
            boolean done = false;
            while (!done && tries < maxTries) {
                try {
                    ++tries;
                    Thread.sleep(sleepTime);
                    done = TransactionUtil.executeInUserTransaction(transactionService, new TransactionUtil.TransactionWork<Boolean>(){

                        @Override
                        public Boolean doWork() {
                            boolean done = test.executeTest();
                            return done;
                        }
                    });
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            if (!done) {
                throw new RuntimeException("Asynchronous action was not executed.");
            }
        }
        catch (Throwable exception) {
            exception.printStackTrace();
            ActionServiceImplTest.fail((String)("An exception was encountered whilst checking the async action was executed: " + exception.getMessage()));
        }
    }

    public void testSyncFailureBehaviour() {
        Action action = this.actionService.createAction("move");
        action.setParameterValue("assoc-type", ContentModel.ASSOC_CHILDREN);
        action.setParameterValue("assoc-name", ContentModel.ASSOC_CHILDREN);
        NodeRef badNodeRef = new NodeRef(this.storeRef, "123123");
        action.setParameterValue("destination-folder", badNodeRef);
        try {
            this.actionService.executeAction(action, this.nodeRef);
            ActionServiceImplTest.fail((String)"An exception should have been raised.");
        }
        catch (RuntimeException exception) {
            // empty catch block
        }
        Action action1 = this.actionService.createAction("add-features");
        action1.setParameterValue("aspect-name", ContentModel.ASPECT_LOCKABLE);
        Action action2 = this.actionService.createAction("add-features");
        action2.setParameterValue("aspect-name", QName.createQName("{test}badDogAspect"));
        CompositeAction compAction = this.actionService.createCompositeAction();
        compAction.setTitle("title");
        compAction.setDescription("description");
        compAction.addAction(action1);
        compAction.addAction(action2);
        try {
            this.actionService.executeAction(compAction, this.nodeRef);
            ActionServiceImplTest.fail((String)"An exception should have been raised here !!");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public void testCompensatingAction() {
        final Action action = this.actionService.createAction("move");
        action.setParameterValue("assoc-type", ContentModel.ASSOC_CHILDREN);
        action.setParameterValue("assoc-name", ContentModel.ASSOC_CHILDREN);
        NodeRef badNodeRef = new NodeRef(this.storeRef, "123123");
        action.setParameterValue("destination-folder", badNodeRef);
        action.setTitle("title");
        Action compensatingAction = this.actionService.createAction("add-features");
        compensatingAction.setParameterValue("aspect-name", ContentModel.ASPECT_CLASSIFIABLE);
        compensatingAction.setTitle("title");
        action.setCompensatingAction(compensatingAction);
        action.setExecuteAsynchronously(true);
        this.actionService.executeAction(action, this.nodeRef);
        this.setComplete();
        this.endTransaction();
        ActionServiceImplTest.postAsyncActionTest(this.transactionService, 1000L, 10, new AsyncTest(){

            public boolean executeTest() {
                return ActionServiceImplTest.this.nodeService.hasAspect(ActionServiceImplTest.this.nodeRef, ContentModel.ASPECT_CLASSIFIABLE);
            }
        });
        compensatingAction.setParameterValue("aspect-name", QName.createQName("{test}badAspect"));
        TransactionUtil.executeInUserTransaction(this.transactionService, new TransactionUtil.TransactionWork<Object>(){

            @Override
            public Object doWork() {
                try {
                    ActionServiceImplTest.this.actionService.executeAction(action, ActionServiceImplTest.this.nodeRef);
                }
                catch (RuntimeException exception) {
                    exception.printStackTrace();
                    Assert.fail((String)"An exception should not have been raised here.");
                }
                return null;
            }
        });
    }

    public static interface AsyncTest {
        public boolean executeTest();
    }
}

