/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.action;

import java.util.List;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.action.ActionModel;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.JavaBehaviour;
import org.alfresco.repo.policy.PolicyComponent;
import org.alfresco.repo.policy.PolicyScope;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.rule.RuleService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.RegexQNamePattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActionsAspect {
    private Behaviour onAddAspectBehaviour;
    private PolicyComponent policyComponent;
    private RuleService ruleService;
    private NodeService nodeService;

    public void setPolicyComponent(PolicyComponent policyComponent) {
        this.policyComponent = policyComponent;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setRuleService(RuleService ruleService) {
        this.ruleService = ruleService;
    }

    public void init() {
        this.policyComponent.bindClassBehaviour(QName.createQName("http://www.alfresco.org", "onCopyNode"), ActionModel.ASPECT_ACTIONS, (Behaviour)new JavaBehaviour(this, "onCopyNode"));
        this.policyComponent.bindClassBehaviour(QName.createQName("http://www.alfresco.org", "onCopyComplete"), ActionModel.ASPECT_ACTIONS, (Behaviour)new JavaBehaviour(this, "onCopyComplete"));
        this.onAddAspectBehaviour = new JavaBehaviour(this, "onAddAspect");
        this.policyComponent.bindClassBehaviour(QName.createQName("http://www.alfresco.org", "onAddAspect"), ActionModel.ASPECT_ACTIONS, this.onAddAspectBehaviour);
    }

    public void disbleOnAddAspect() {
        this.onAddAspectBehaviour.disable();
    }

    public void enableOnAddAspect() {
        this.onAddAspectBehaviour.enable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onAddAspect(NodeRef nodeRef, QName aspectTypeQName) {
        this.ruleService.disableRules(nodeRef);
        try {
            this.nodeService.createNode(nodeRef, ActionModel.ASSOC_ACTION_FOLDER, ActionModel.ASSOC_ACTION_FOLDER, ContentModel.TYPE_SYSTEM_FOLDER);
        }
        finally {
            this.ruleService.enableRules(nodeRef);
        }
    }

    public void onCopyNode(QName classRef, NodeRef sourceNodeRef, StoreRef destinationStoreRef, boolean copyToNewNode, PolicyScope copyDetails) {
        copyDetails.addAspect(ActionModel.ASPECT_ACTIONS);
        List<ChildAssociationRef> assocs = this.nodeService.getChildAssocs(sourceNodeRef, RegexQNamePattern.MATCH_ALL, ActionModel.ASSOC_ACTION_FOLDER);
        for (ChildAssociationRef assoc : assocs) {
            copyDetails.addChildAssociation(classRef, assoc, true);
        }
        this.onAddAspectBehaviour.disable();
    }

    public void onCopyComplete(QName classRef, NodeRef sourceNodeRef, NodeRef destinationRef, boolean copyToNew, Map<NodeRef, NodeRef> copyMap) {
        this.onAddAspectBehaviour.enable();
    }
}

