/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.action;

import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.alfresco.repo.action.ActionImpl;
import org.alfresco.repo.action.AsynchronousActionExecutionQueue;
import org.alfresco.repo.action.RuntimeActionService;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.transaction.TransactionUtil;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ActionServiceException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.transaction.TransactionService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsynchronousActionExecutionQueueImpl
extends ThreadPoolExecutor
implements AsynchronousActionExecutionQueue {
    private static final int CORE_POOL_SIZE = 2;
    private static final int MAX_POOL_SIZE = 5;
    private static final long KEEP_ALIVE = 30L;
    private static final TimeUnit TIME_UNIT = TimeUnit.SECONDS;
    private static final int MAX_QUEUE_SIZE = 500;
    private TransactionService transactionService;
    private AuthenticationComponent authenticationComponent;

    public AsynchronousActionExecutionQueueImpl() {
        super(2, 5, 30L, TIME_UNIT, new ArrayBlockingQueue<Runnable>(500, true));
    }

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    public void setAuthenticationComponent(AuthenticationComponent authenticationComponent) {
        this.authenticationComponent = authenticationComponent;
    }

    @Override
    public void executeAction(RuntimeActionService actionService, Action action, NodeRef actionedUponNodeRef, boolean checkConditions, Set<String> actionChain) {
        this.executeAction(actionService, action, actionedUponNodeRef, checkConditions, actionChain, null);
    }

    public void executeAction(RuntimeActionService actionService, Action action, NodeRef actionedUponNodeRef, boolean checkConditions, Set<String> actionChain, NodeRef actionExecutionHistoryNodeRef) {
        this.execute(new ActionExecutionWrapper(actionService, this.transactionService, this.authenticationComponent, action, actionedUponNodeRef, checkConditions, actionExecutionHistoryNodeRef, actionChain));
    }

    @Override
    protected void beforeExecute(Thread thread, Runnable runnable) {
        super.beforeExecute(thread, runnable);
    }

    @Override
    protected void afterExecute(Runnable thread, Throwable runnable) {
        super.afterExecute(thread, runnable);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ActionExecutionWrapper
    implements Runnable {
        private RuntimeActionService actionService;
        private TransactionService transactionService;
        private AuthenticationComponent authenticationComponent;
        private Action action;
        private NodeRef actionedUponNodeRef;
        private boolean checkConditions;
        private NodeRef actionExecutionHistoryNodeRef;
        private Set<String> actionChain;

        public ActionExecutionWrapper(RuntimeActionService actionService, TransactionService transactionService, AuthenticationComponent authenticationComponent, Action action, NodeRef actionedUponNodeRef, boolean checkConditions, NodeRef actionExecutionHistoryNodeRef, Set<String> actionChain) {
            this.actionService = actionService;
            this.transactionService = transactionService;
            this.authenticationComponent = authenticationComponent;
            this.actionedUponNodeRef = actionedUponNodeRef;
            this.action = action;
            this.checkConditions = checkConditions;
            this.actionExecutionHistoryNodeRef = actionExecutionHistoryNodeRef;
            this.actionChain = actionChain;
        }

        public Action getAction() {
            return this.action;
        }

        public NodeRef getActionedUponNodeRef() {
            return this.actionedUponNodeRef;
        }

        public boolean getCheckCondtions() {
            return this.checkConditions;
        }

        public NodeRef getActionExecutionHistoryNodeRef() {
            return this.actionExecutionHistoryNodeRef;
        }

        public Set<String> getActionChain() {
            return this.actionChain;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                String userName = ((ActionImpl)this.action).getRunAsUser();
                if (userName == null) {
                    throw new ActionServiceException("Cannot execute action asynchronously since run as user is 'null'");
                }
                this.authenticationComponent.setCurrentUser(userName);
                try {
                    TransactionUtil.executeInNonPropagatingUserTransaction(this.transactionService, new TransactionUtil.TransactionWork<Object>(){

                        @Override
                        public Object doWork() {
                            ActionExecutionWrapper.this.actionService.executeActionImpl(ActionExecutionWrapper.this.action, ActionExecutionWrapper.this.actionedUponNodeRef, ActionExecutionWrapper.this.checkConditions, true, ActionExecutionWrapper.this.actionChain);
                            return null;
                        }
                    });
                }
                finally {
                    this.authenticationComponent.clearCurrentSecurityContext();
                }
            }
            catch (Throwable exception) {
                exception.printStackTrace();
            }
        }
    }
}

