/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.action;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.alfresco.i18n.I18NUtil;
import org.alfresco.repo.action.CommonResourceAbstractBase;
import org.alfresco.repo.action.RuntimeActionService;
import org.alfresco.service.cmr.action.ParameterDefinition;
import org.alfresco.service.cmr.action.ParameterizedItem;
import org.alfresco.service.cmr.action.ParameterizedItemDefinition;
import org.alfresco.service.cmr.rule.RuleServiceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ParameterizedItemAbstractBase
extends CommonResourceAbstractBase {
    private static final String ERR_MAND_PROP = "A value for the mandatory parameter {0} has not been set on the rule item {1}";
    private static final String TITLE = "title";
    private static final String DESCRIPTION = "description";
    private static final String DISPLAY_LABEL = "display-label";
    protected RuntimeActionService runtimeActionService;

    public String toString() {
        StringBuilder sb = new StringBuilder(60);
        sb.append("ParameterizedItem").append("[ title='").append(this.getTitleKey()).append("'").append(", description='").append(this.getDescriptionKey()).append("'").append("]");
        return sb.toString();
    }

    protected List<ParameterDefinition> getParameterDefintions() {
        ArrayList<ParameterDefinition> result = new ArrayList<ParameterDefinition>();
        this.addParameterDefinitions(result);
        return result;
    }

    protected abstract void addParameterDefinitions(List<ParameterDefinition> var1);

    public void setRuntimeActionService(RuntimeActionService runtimeActionService) {
        this.runtimeActionService = runtimeActionService;
    }

    protected String getTitleKey() {
        return this.name + "." + TITLE;
    }

    protected String getDescriptionKey() {
        return this.name + "." + DESCRIPTION;
    }

    protected boolean getAdhocPropertiesAllowed() {
        return false;
    }

    protected String getParamDisplayLabel(String paramName) {
        return I18NUtil.getMessage((String)(this.name + "." + paramName + "." + DISPLAY_LABEL));
    }

    protected void checkMandatoryProperties(ParameterizedItem ruleItem, ParameterizedItemDefinition ruleItemDefinition) {
        List<ParameterDefinition> definitions = ruleItemDefinition.getParameterDefinitions();
        for (ParameterDefinition definition : definitions) {
            if (!definition.isMandatory() || ruleItem.getParameterValue(definition.getName()) != null) continue;
            throw new RuleServiceException(MessageFormat.format(ERR_MAND_PROP, definition.getName(), ruleItemDefinition.getName()));
        }
    }
}

