/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.action.evaluator;

import org.alfresco.model.ContentModel;
import org.alfresco.repo.action.ActionConditionImpl;
import org.alfresco.repo.action.evaluator.HasAspectEvaluator;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.BaseSpringTest;
import org.alfresco.util.GUID;

public class HasAspectEvaluatorTest
extends BaseSpringTest {
    private NodeService nodeService;
    private StoreRef testStoreRef;
    private NodeRef rootNodeRef;
    private NodeRef nodeRef;
    private HasAspectEvaluator evaluator;
    private static final String ID = GUID.generate();

    protected void onSetUpInTransaction() throws Exception {
        this.nodeService = (NodeService)this.applicationContext.getBean("nodeService");
        this.testStoreRef = this.nodeService.createStore("workspace", "Test_" + System.currentTimeMillis());
        this.rootNodeRef = this.nodeService.getRootNode(this.testStoreRef);
        this.nodeRef = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName("{test}testnode"), ContentModel.TYPE_CONTENT).getChildRef();
        this.evaluator = (HasAspectEvaluator)this.applicationContext.getBean("has-aspect");
    }

    public void testMandatoryParamsMissing() {
        ActionConditionImpl condition = new ActionConditionImpl(ID, "has-aspect", null);
        try {
            this.evaluator.evaluate(condition, this.nodeRef);
            HasAspectEvaluatorTest.fail((String)"The fact that a mandatory parameter has not been set should have been detected.");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void testPass() {
        this.nodeService.addAspect(this.nodeRef, ContentModel.ASPECT_VERSIONABLE, null);
        ActionConditionImpl condition = new ActionConditionImpl(ID, "has-aspect", null);
        condition.setParameterValue("aspect", ContentModel.ASPECT_VERSIONABLE);
        HasAspectEvaluatorTest.assertTrue((boolean)this.evaluator.evaluate(condition, this.nodeRef));
    }

    public void testFail() {
        ActionConditionImpl condition = new ActionConditionImpl(ID, "has-aspect", null);
        condition.setParameterValue("aspect", ContentModel.ASPECT_VERSIONABLE);
        HasAspectEvaluatorTest.assertFalse((boolean)this.evaluator.evaluate(condition, this.nodeRef));
    }
}

