/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.action.evaluator;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.action.ParameterDefinitionImpl;
import org.alfresco.repo.action.evaluator.ActionConditionEvaluatorAbstractBase;
import org.alfresco.service.cmr.action.ActionCondition;
import org.alfresco.service.cmr.action.ParameterDefinition;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InCategoryEvaluator
extends ActionConditionEvaluatorAbstractBase {
    public static final String NAME = "in-category";
    public static final String PARAM_CATEGORY_ASPECT = "category-aspect";
    public static final String PARAM_CATEGORY_VALUE = "category-value";
    private NodeService nodeService;
    private DictionaryService dictionaryService;

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    @Override
    protected void addParameterDefinitions(List<ParameterDefinition> paramList) {
        paramList.add(new ParameterDefinitionImpl(PARAM_CATEGORY_ASPECT, DataTypeDefinition.QNAME, true, this.getParamDisplayLabel(PARAM_CATEGORY_ASPECT)));
        paramList.add(new ParameterDefinitionImpl(PARAM_CATEGORY_VALUE, DataTypeDefinition.NODE_REF, true, this.getParamDisplayLabel(PARAM_CATEGORY_VALUE)));
    }

    @Override
    protected boolean evaluateImpl(ActionCondition ruleCondition, NodeRef actionedUponNodeRef) {
        boolean result = false;
        if (this.nodeService.exists(actionedUponNodeRef)) {
            QName categoryAspect = (QName)ruleCondition.getParameterValue(PARAM_CATEGORY_ASPECT);
            NodeRef categoryValue = (NodeRef)ruleCondition.getParameterValue(PARAM_CATEGORY_VALUE);
            if (this.dictionaryService.isSubClass(categoryAspect, ContentModel.ASPECT_CLASSIFIABLE) && this.nodeService.hasAspect(actionedUponNodeRef, categoryAspect)) {
                Serializable value;
                QName categoryProperty = null;
                Map<QName, PropertyDefinition> propertyDefs = this.dictionaryService.getAspect(categoryAspect).getProperties();
                for (Map.Entry<QName, PropertyDefinition> entry : propertyDefs.entrySet()) {
                    if (!DataTypeDefinition.CATEGORY.equals(entry.getValue().getDataType().getName())) continue;
                    categoryProperty = entry.getKey();
                    break;
                }
                if (categoryProperty != null && (value = this.nodeService.getProperty(actionedUponNodeRef, categoryProperty)) != null) {
                    Collection<NodeRef> actualCategories = DefaultTypeConverter.INSTANCE.getCollection(NodeRef.class, value);
                    for (NodeRef nodeRef : actualCategories) {
                        if (nodeRef == null || !nodeRef.equals(categoryValue)) continue;
                        result = true;
                        break;
                    }
                }
            }
        }
        return result;
    }
}

