/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.action.executer;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.action.executer.ActionExecuterAbstractBase;
import org.alfresco.repo.content.metadata.MetadataExtracter;
import org.alfresco.repo.content.metadata.MetadataExtracterRegistry;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ParameterDefinition;
import org.alfresco.service.cmr.dictionary.ClassDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContentMetadataExtracter
extends ActionExecuterAbstractBase {
    public static final String NAME = "extract-metadata";
    private NodeService nodeService;
    private ContentService contentService;
    private DictionaryService dictionaryService;
    private MetadataExtracterRegistry metadataExtracterRegistry;

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    public void setDictionaryService(DictionaryService dictService) {
        this.dictionaryService = dictService;
    }

    public void setMetadataExtracterRegistry(MetadataExtracterRegistry metadataExtracterRegistry) {
        this.metadataExtracterRegistry = metadataExtracterRegistry;
    }

    @Override
    public void executeImpl(Action ruleAction, NodeRef actionedUponNodeRef) {
        MetadataExtracter me;
        ContentReader cr;
        if (this.nodeService.exists(actionedUponNodeRef) && (cr = this.contentService.getReader(actionedUponNodeRef, ContentModel.PROP_CONTENT)) != null && cr.getMimetype() != null && (me = this.metadataExtracterRegistry.getExtracter(cr.getMimetype())) != null) {
            HashMap<QName, Serializable> newProps = new HashMap<QName, Serializable>(7, 0.5f);
            me.extract(cr, newProps);
            Map<QName, Serializable> allProps = this.nodeService.getProperties(actionedUponNodeRef);
            boolean changed = false;
            for (QName key : newProps.keySet()) {
                Serializable oldValue;
                Serializable value;
                ClassDefinition propClass = this.dictionaryService.getProperty(key).getContainerClass();
                if (propClass.isAspect() && !this.nodeService.hasAspect(actionedUponNodeRef, propClass.getName())) {
                    HashMap<QName, Serializable> aspectProps = new HashMap<QName, Serializable>(3, 1.0f);
                    for (QName defKey : propClass.getProperties().keySet()) {
                        if (!this.dictionaryService.getProperty(defKey).isMandatory()) continue;
                        aspectProps.put(defKey, allProps.get(defKey));
                        allProps.remove(defKey);
                    }
                    this.nodeService.addAspect(actionedUponNodeRef, propClass.getName(), aspectProps);
                }
                if ((value = (Serializable)newProps.get(key)) == null || (oldValue = allProps.get(key)) != null && oldValue.toString().length() != 0) continue;
                allProps.put(key, value);
                changed = true;
            }
            if (changed) {
                this.nodeService.setProperties(actionedUponNodeRef, allProps);
            }
        }
    }

    @Override
    protected void addParameterDefinitions(List<ParameterDefinition> arg0) {
    }
}

