/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.action.executer;

import java.io.Serializable;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.action.ActionImpl;
import org.alfresco.repo.action.executer.ContentMetadataExtracter;
import org.alfresco.repo.content.transform.AbstractContentTransformerTest;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.BaseSpringTest;
import org.alfresco.util.GUID;

public class ContentMetadataExtracterTest
extends BaseSpringTest {
    protected static final String QUICK_TITLE = "The quick brown fox jumps over the lazy dog";
    protected static final String QUICK_DESCRIPTION = "Gym class featuring a brown fox and lazy dog";
    protected static final String QUICK_CREATOR = "Nevin Nollop";
    private NodeService nodeService;
    private ContentService contentService;
    private StoreRef testStoreRef;
    private NodeRef rootNodeRef;
    private NodeRef nodeRef;
    private ContentMetadataExtracter executer;
    private static final String ID = GUID.generate();

    protected void onSetUpInTransaction() throws Exception {
        this.nodeService = (NodeService)this.applicationContext.getBean("nodeService");
        this.contentService = (ContentService)this.applicationContext.getBean("contentService");
        AuthenticationComponent authenticationComponent = (AuthenticationComponent)this.applicationContext.getBean("authenticationComponent");
        authenticationComponent.setSystemUserAsCurrentUser();
        this.testStoreRef = this.nodeService.createStore("workspace", "Test_" + System.currentTimeMillis());
        this.rootNodeRef = this.nodeService.getRootNode(this.testStoreRef);
        this.nodeRef = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName("{test}testnode"), ContentModel.TYPE_CONTENT).getChildRef();
        ContentWriter cw = this.contentService.getWriter(this.nodeRef, ContentModel.PROP_CONTENT, true);
        cw.setMimetype("application/pdf");
        cw.putContent(AbstractContentTransformerTest.loadQuickTestFile("pdf"));
        this.executer = (ContentMetadataExtracter)this.applicationContext.getBean("extract-metadata");
    }

    public void testFromBlanks() {
        Map<QName, Serializable> props = this.nodeService.getProperties(this.nodeRef);
        props.remove(ContentModel.PROP_AUTHOR);
        props.put(ContentModel.PROP_TITLE, (Serializable)((Object)""));
        props.put(ContentModel.PROP_DESCRIPTION, null);
        this.nodeService.setProperties(this.nodeRef, props);
        ActionImpl action = new ActionImpl(ID, "set-property-value", null);
        this.executer.execute(action, this.nodeRef);
        ContentMetadataExtracterTest.assertEquals((Object)QUICK_TITLE, (Object)this.nodeService.getProperty(this.nodeRef, ContentModel.PROP_TITLE));
        ContentMetadataExtracterTest.assertEquals((Object)QUICK_DESCRIPTION, (Object)this.nodeService.getProperty(this.nodeRef, ContentModel.PROP_DESCRIPTION));
        ContentMetadataExtracterTest.assertEquals((Object)QUICK_CREATOR, (Object)this.nodeService.getProperty(this.nodeRef, ContentModel.PROP_AUTHOR));
    }

    public void testFromPartial() {
        String myCreator = "Null-op";
        String myTitle = "The hot dog is eaten by the city fox";
        Map<QName, Serializable> props = this.nodeService.getProperties(this.nodeRef);
        props.put(ContentModel.PROP_AUTHOR, (Serializable)((Object)myCreator));
        props.put(ContentModel.PROP_TITLE, (Serializable)((Object)myTitle));
        props.remove(ContentModel.PROP_DESCRIPTION);
        this.nodeService.setProperties(this.nodeRef, props);
        ActionImpl action = new ActionImpl(ID, "set-property-value", null);
        this.executer.execute(action, this.nodeRef);
        ContentMetadataExtracterTest.assertEquals((Object)myTitle, (Object)this.nodeService.getProperty(this.nodeRef, ContentModel.PROP_TITLE));
        ContentMetadataExtracterTest.assertEquals((Object)myCreator, (Object)this.nodeService.getProperty(this.nodeRef, ContentModel.PROP_AUTHOR));
        ContentMetadataExtracterTest.assertEquals((Object)QUICK_DESCRIPTION, (Object)this.nodeService.getProperty(this.nodeRef, ContentModel.PROP_DESCRIPTION));
    }
}

