/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.action.executer;

import java.util.List;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.action.ParameterDefinitionImpl;
import org.alfresco.repo.action.executer.ActionExecuterAbstractBase;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ActionService;
import org.alfresco.service.cmr.action.ParameterDefinition;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.rule.Rule;
import org.alfresco.service.cmr.rule.RuleService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExecuteAllRulesActionExecuter
extends ActionExecuterAbstractBase {
    public static final String NAME = "execute-all-rules";
    public static final String PARAM_EXECUTE_INHERITED_RULES = "execute-inherited-rules";
    private NodeService nodeService;
    private RuleService ruleService;
    private ActionService actionService;
    private DictionaryService dictionaryService;

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setRuleService(RuleService ruleService) {
        this.ruleService = ruleService;
    }

    public void setActionService(ActionService actionService) {
        this.actionService = actionService;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    @Override
    public void executeImpl(Action ruleAction, NodeRef actionedUponNodeRef) {
        if (this.nodeService.exists(actionedUponNodeRef)) {
            List<Rule> rules;
            boolean includeInherited = false;
            Boolean includeInheritedValue = (Boolean)ruleAction.getParameterValue(PARAM_EXECUTE_INHERITED_RULES);
            if (includeInheritedValue != null) {
                includeInherited = includeInheritedValue;
            }
            if ((rules = this.ruleService.getRules(actionedUponNodeRef, includeInherited)) != null && !rules.isEmpty()) {
                List<ChildAssociationRef> children = this.nodeService.getChildAssocs(actionedUponNodeRef);
                for (ChildAssociationRef childAssoc : children) {
                    NodeRef child = childAssoc.getChildRef();
                    if (this.dictionaryService.isSubClass(this.nodeService.getType(child), ContentModel.TYPE_SYSTEM_FOLDER)) continue;
                    for (Rule rule : rules) {
                        this.actionService.executeAction(rule, child);
                    }
                }
            }
        }
    }

    @Override
    protected void addParameterDefinitions(List<ParameterDefinition> paramList) {
        paramList.add(new ParameterDefinitionImpl(PARAM_EXECUTE_INHERITED_RULES, DataTypeDefinition.BOOLEAN, false, this.getParamDisplayLabel(PARAM_EXECUTE_INHERITED_RULES)));
    }
}

