/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.action.executer;

import org.alfresco.model.ContentModel;
import org.alfresco.repo.action.ActionImpl;
import org.alfresco.repo.action.executer.ExecuteAllRulesActionExecuter;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ActionService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.rule.Rule;
import org.alfresco.service.cmr.rule.RuleService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.BaseSpringTest;
import org.alfresco.util.GUID;

public class ExecuteAllRulesActionExecuterTest
extends BaseSpringTest {
    private NodeService nodeService;
    private RuleService ruleService;
    private ActionService actionService;
    private StoreRef testStoreRef;
    private NodeRef rootNodeRef;
    private ExecuteAllRulesActionExecuter executer;
    private static final String ID = GUID.generate();

    protected void onSetUpInTransaction() throws Exception {
        this.nodeService = (NodeService)this.applicationContext.getBean("nodeService");
        this.ruleService = (RuleService)this.applicationContext.getBean("ruleService");
        this.actionService = (ActionService)this.applicationContext.getBean("actionService");
        AuthenticationComponent authenticationComponent = (AuthenticationComponent)this.applicationContext.getBean("authenticationComponent");
        authenticationComponent.setCurrentUser(authenticationComponent.getSystemUserName());
        this.testStoreRef = this.nodeService.createStore("workspace", "Test_" + System.currentTimeMillis());
        this.rootNodeRef = this.nodeService.getRootNode(this.testStoreRef);
        this.executer = (ExecuteAllRulesActionExecuter)this.applicationContext.getBean("execute-all-rules");
    }

    public void testExecution() {
        NodeRef folder = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName("{test}folderOne"), ContentModel.TYPE_FOLDER).getChildRef();
        NodeRef doc1 = this.nodeService.createNode(folder, ContentModel.ASSOC_CHILDREN, QName.createQName("{test}docOne"), ContentModel.TYPE_CONTENT).getChildRef();
        NodeRef doc2 = this.nodeService.createNode(folder, ContentModel.ASSOC_CHILDREN, QName.createQName("{test}docTwo"), ContentModel.TYPE_CONTENT).getChildRef();
        Rule rule1 = this.ruleService.createRule("inbound");
        Action action1 = this.actionService.createAction("add-features");
        action1.setParameterValue("aspect-name", ContentModel.ASPECT_VERSIONABLE);
        rule1.addAction(action1);
        this.ruleService.saveRule(folder, rule1);
        Rule rule2 = this.ruleService.createRule("inbound");
        Action action2 = this.actionService.createAction("add-features");
        action2.setParameterValue("aspect-name", ContentModel.ASPECT_CLASSIFIABLE);
        rule2.addAction(action2);
        this.ruleService.saveRule(folder, rule2);
        ExecuteAllRulesActionExecuterTest.assertFalse((boolean)this.nodeService.hasAspect(doc1, ContentModel.ASPECT_VERSIONABLE));
        ExecuteAllRulesActionExecuterTest.assertFalse((boolean)this.nodeService.hasAspect(doc1, ContentModel.ASPECT_CLASSIFIABLE));
        ExecuteAllRulesActionExecuterTest.assertFalse((boolean)this.nodeService.hasAspect(doc2, ContentModel.ASPECT_VERSIONABLE));
        ExecuteAllRulesActionExecuterTest.assertFalse((boolean)this.nodeService.hasAspect(doc2, ContentModel.ASPECT_CLASSIFIABLE));
        ExecuteAllRulesActionExecuterTest.assertTrue((boolean)this.nodeService.exists(folder));
        ActionImpl action = new ActionImpl(ID, "execute-all-rules", null);
        this.executer.execute(action, folder);
        ExecuteAllRulesActionExecuterTest.assertTrue((boolean)this.nodeService.hasAspect(doc1, ContentModel.ASPECT_VERSIONABLE));
        ExecuteAllRulesActionExecuterTest.assertTrue((boolean)this.nodeService.hasAspect(doc1, ContentModel.ASPECT_CLASSIFIABLE));
        ExecuteAllRulesActionExecuterTest.assertTrue((boolean)this.nodeService.hasAspect(doc2, ContentModel.ASPECT_VERSIONABLE));
        ExecuteAllRulesActionExecuterTest.assertTrue((boolean)this.nodeService.hasAspect(doc2, ContentModel.ASPECT_CLASSIFIABLE));
    }
}

