/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.action.executer;

import java.util.HashMap;
import java.util.List;
import org.alfresco.repo.action.ParameterDefinitionImpl;
import org.alfresco.repo.action.executer.TransformActionExecuter;
import org.alfresco.repo.content.transform.magick.ImageMagickContentTransformer;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ParameterDefinition;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NoTransformerException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImageTransformActionExecuter
extends TransformActionExecuter {
    public static final String NAME = "transform-image";
    public static final String PARAM_CONVERT_COMMAND = "convert-command";
    private ImageMagickContentTransformer imageMagickContentTransformer;

    public void setImageMagickContentTransformer(ImageMagickContentTransformer imageMagickContentTransformer) {
        this.imageMagickContentTransformer = imageMagickContentTransformer;
    }

    @Override
    protected void addParameterDefinitions(List<ParameterDefinition> paramList) {
        super.addParameterDefinitions(paramList);
        paramList.add(new ParameterDefinitionImpl(PARAM_CONVERT_COMMAND, DataTypeDefinition.TEXT, false, this.getParamDisplayLabel(PARAM_CONVERT_COMMAND)));
    }

    @Override
    protected void doTransform(Action ruleAction, ContentReader contentReader, ContentWriter contentWriter) {
        if (!this.imageMagickContentTransformer.isAvailable()) {
            throw new NoTransformerException(contentReader.getMimetype(), contentWriter.getMimetype());
        }
        String convertCommand = (String)((Object)ruleAction.getParameterValue(PARAM_CONVERT_COMMAND));
        HashMap<String, Object> options = new HashMap<String, Object>(5);
        options.put("options", convertCommand);
        this.imageMagickContentTransformer.transform(contentReader, contentWriter, options);
    }
}

