/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.action.executer;

import java.io.File;
import java.util.List;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.action.ParameterDefinitionImpl;
import org.alfresco.repo.action.executer.ActionExecuterAbstractBase;
import org.alfresco.repo.importer.ACPImportPackageHandler;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ParameterDefinition;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.view.ImporterService;
import org.alfresco.service.cmr.view.Location;
import org.alfresco.util.TempFileProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImporterActionExecuter
extends ActionExecuterAbstractBase {
    public static final String NAME = "import";
    public static final String PARAM_ENCODING = "encoding";
    public static final String PARAM_DESTINATION_FOLDER = "destination";
    private static final String TEMP_FILE_PREFIX = "alf";
    private static final String TEMP_FILE_SUFFIX = ".acp";
    private ImporterService importerService;
    private NodeService nodeService;
    private ContentService contentService;

    public void setImporterService(ImporterService importerService) {
        this.importerService = importerService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeImpl(Action ruleAction, NodeRef actionedUponNodeRef) {
        ContentReader reader;
        if (this.nodeService.exists(actionedUponNodeRef) && (reader = this.contentService.getReader(actionedUponNodeRef, ContentModel.PROP_CONTENT)) != null && "application/acp".equals(reader.getMimetype())) {
            File zipFile = null;
            try {
                zipFile = TempFileProvider.createTempFile((String)TEMP_FILE_PREFIX, (String)TEMP_FILE_SUFFIX);
                reader.getContent(zipFile);
                ACPImportPackageHandler importHandler = new ACPImportPackageHandler(zipFile, (String)((Object)ruleAction.getParameterValue(PARAM_ENCODING)));
                NodeRef importDest = (NodeRef)ruleAction.getParameterValue(PARAM_DESTINATION_FOLDER);
                this.importerService.importView(importHandler, new Location(importDest), null, null);
            }
            finally {
                if (zipFile != null) {
                    zipFile.delete();
                }
            }
        }
    }

    @Override
    protected void addParameterDefinitions(List<ParameterDefinition> paramList) {
        paramList.add(new ParameterDefinitionImpl(PARAM_DESTINATION_FOLDER, DataTypeDefinition.NODE_REF, true, this.getParamDisplayLabel(PARAM_DESTINATION_FOLDER)));
        paramList.add(new ParameterDefinitionImpl(PARAM_ENCODING, DataTypeDefinition.TEXT, true, this.getParamDisplayLabel(PARAM_ENCODING)));
    }
}

