/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.action.executer;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.action.ParameterDefinitionImpl;
import org.alfresco.repo.action.executer.ActionExecuterAbstractBase;
import org.alfresco.repo.template.DateCompareMethod;
import org.alfresco.repo.template.HasAspectMethod;
import org.alfresco.repo.template.I18NMessageMethod;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ParameterDefinition;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.TemplateNode;
import org.alfresco.service.cmr.repository.TemplateService;
import org.alfresco.service.cmr.security.AuthenticationService;
import org.alfresco.service.cmr.security.AuthorityService;
import org.alfresco.service.cmr.security.AuthorityType;
import org.alfresco.service.cmr.security.PersonService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.mail.javamail.MimeMessagePreparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MailActionExecuter
extends ActionExecuterAbstractBase {
    private static Log logger = LogFactory.getLog(MailActionExecuter.class);
    public static final String NAME = "mail";
    public static final String PARAM_TO = "to";
    public static final String PARAM_TO_MANY = "to_many";
    public static final String PARAM_SUBJECT = "subject";
    public static final String PARAM_TEXT = "text";
    public static final String PARAM_FROM = "from";
    public static final String PARAM_TEMPLATE = "template";
    public static final String FROM_ADDRESS = "alfresco_repository@alfresco.org";
    private JavaMailSender javaMailSender;
    private TemplateService templateService;
    private PersonService personService;
    private AuthenticationService authService;
    private NodeService nodeService;
    private AuthorityService authorityService;
    private ServiceRegistry serviceRegistry;

    public void setMailService(JavaMailSender javaMailSender) {
        this.javaMailSender = javaMailSender;
    }

    public void setTemplateService(TemplateService templateService) {
        this.templateService = templateService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    public void setAuthenticationService(AuthenticationService authService) {
        this.authService = authService;
    }

    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    public void setAuthorityService(AuthorityService authorityService) {
        this.authorityService = authorityService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    @Override
    protected void executeImpl(final Action ruleAction, final NodeRef actionedUponNodeRef) {
        MimeMessagePreparator mailPreparer = new MimeMessagePreparator(){

            public void prepare(MimeMessage mimeMessage) throws MessagingException {
                MimeMessageHelper message = new MimeMessageHelper(mimeMessage);
                String to = (String)((Object)ruleAction.getParameterValue(MailActionExecuter.PARAM_TO));
                if (to != null && to.length() != 0) {
                    message.setTo(to);
                } else {
                    List authorities = (List)((Object)ruleAction.getParameterValue(MailActionExecuter.PARAM_TO_MANY));
                    if (authorities != null && authorities.size() != 0) {
                        ArrayList<String> recipients = new ArrayList<String>(authorities.size());
                        for (String authority : authorities) {
                            AuthorityType authType = AuthorityType.getAuthorityType(authority);
                            if (authType.equals((Object)AuthorityType.USER)) {
                                if (!MailActionExecuter.this.personService.personExists(authority)) continue;
                                NodeRef person = MailActionExecuter.this.personService.getPerson(authority);
                                String address = (String)((Object)MailActionExecuter.this.nodeService.getProperty(person, ContentModel.PROP_EMAIL));
                                if (address == null || address.length() == 0) continue;
                                recipients.add(address);
                                continue;
                            }
                            if (!authType.equals((Object)AuthorityType.GROUP)) continue;
                            Set<String> users = MailActionExecuter.this.authorityService.getContainedAuthorities(AuthorityType.USER, authority, false);
                            for (String userAuth : users) {
                                if (!MailActionExecuter.this.personService.personExists(userAuth)) continue;
                                NodeRef person = MailActionExecuter.this.personService.getPerson(authority);
                                String address = (String)((Object)MailActionExecuter.this.nodeService.getProperty(person, ContentModel.PROP_EMAIL));
                                if (address == null || address.length() == 0) continue;
                                recipients.add(address);
                            }
                        }
                        message.setTo(recipients.toArray(new String[recipients.size()]));
                    }
                }
                message.setSubject((String)((Object)ruleAction.getParameterValue(MailActionExecuter.PARAM_SUBJECT)));
                String text = null;
                NodeRef templateRef = (NodeRef)ruleAction.getParameterValue(MailActionExecuter.PARAM_TEMPLATE);
                if (templateRef != null) {
                    Map model = MailActionExecuter.this.createEmailTemplateModel(actionedUponNodeRef);
                    text = MailActionExecuter.this.templateService.processTemplate("freemarker", templateRef.toString(), model);
                }
                if (text == null) {
                    text = (String)((Object)ruleAction.getParameterValue(MailActionExecuter.PARAM_TEXT));
                }
                message.setText(text);
                String from = (String)((Object)ruleAction.getParameterValue(MailActionExecuter.PARAM_FROM));
                if (from != null) {
                    message.setFrom(from);
                } else {
                    message.setFrom(MailActionExecuter.FROM_ADDRESS);
                }
            }
        };
        try {
            this.javaMailSender.send(mailPreparer);
        }
        catch (Throwable e) {
            logger.error((Object)("Failed to send email to " + (String)((Object)ruleAction.getParameterValue(PARAM_TO))), e);
        }
    }

    private Map<String, Object> createEmailTemplateModel(NodeRef ref) {
        HashMap<String, Object> model = new HashMap<String, Object>(8, 1.0f);
        NodeRef person = this.personService.getPerson(this.authService.getCurrentUserName());
        model.put("person", new TemplateNode(person, this.serviceRegistry, null));
        model.put("document", new TemplateNode(ref, this.serviceRegistry, null));
        NodeRef parent = this.serviceRegistry.getNodeService().getPrimaryParent(ref).getParentRef();
        model.put("space", new TemplateNode(parent, this.serviceRegistry, null));
        model.put("date", new Date());
        model.put("hasAspect", new HasAspectMethod());
        model.put("message", new I18NMessageMethod());
        model.put("dateCompare", new DateCompareMethod());
        return model;
    }

    @Override
    protected void addParameterDefinitions(List<ParameterDefinition> paramList) {
        paramList.add(new ParameterDefinitionImpl(PARAM_TO, DataTypeDefinition.TEXT, false, this.getParamDisplayLabel(PARAM_TO)));
        paramList.add(new ParameterDefinitionImpl(PARAM_TO_MANY, DataTypeDefinition.ANY, false, this.getParamDisplayLabel(PARAM_TO_MANY)));
        paramList.add(new ParameterDefinitionImpl(PARAM_SUBJECT, DataTypeDefinition.TEXT, true, this.getParamDisplayLabel(PARAM_SUBJECT)));
        paramList.add(new ParameterDefinitionImpl(PARAM_TEXT, DataTypeDefinition.TEXT, true, this.getParamDisplayLabel(PARAM_TEXT)));
        paramList.add(new ParameterDefinitionImpl(PARAM_FROM, DataTypeDefinition.TEXT, false, this.getParamDisplayLabel(PARAM_FROM)));
        paramList.add(new ParameterDefinitionImpl(PARAM_TEMPLATE, DataTypeDefinition.NODE_REF, false, this.getParamDisplayLabel(PARAM_TEMPLATE)));
    }
}

