/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.action.executer;

import java.util.List;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.action.ParameterDefinitionImpl;
import org.alfresco.repo.action.executer.ActionExecuterAbstractBase;
import org.alfresco.repo.jscript.RhinoScriptService;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ParameterDefinition;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.security.PersonService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScriptActionExecutor
extends ActionExecuterAbstractBase {
    public static final String NAME = "script";
    public static final String PARAM_SCRIPTREF = "script-ref";
    public static final String PARAM_SPACEREF = "space-ref";
    private ServiceRegistry serviceRegistry;
    private PersonService personService;
    private String companyHomePath;
    private StoreRef storeRef;

    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    public void setStoreUrl(String storeUrl) {
        this.storeRef = new StoreRef(storeUrl);
    }

    public void setCompanyHomePath(String companyHomePath) {
        this.companyHomePath = companyHomePath;
    }

    @Override
    protected void executeImpl(Action action, NodeRef actionedUponNodeRef) {
        NodeService nodeService = this.serviceRegistry.getNodeService();
        if (nodeService.exists(actionedUponNodeRef)) {
            NodeRef scriptRef = (NodeRef)action.getParameterValue(PARAM_SCRIPTREF);
            NodeRef spaceRef = (NodeRef)action.getParameterValue(PARAM_SPACEREF);
            if (spaceRef == null) {
                spaceRef = nodeService.getPrimaryParent(actionedUponNodeRef).getParentRef();
            }
            if (nodeService.exists(scriptRef)) {
                String userName = this.serviceRegistry.getAuthenticationService().getCurrentUserName();
                NodeRef personRef = this.personService.getPerson(userName);
                NodeRef homeSpaceRef = (NodeRef)nodeService.getProperty(personRef, ContentModel.PROP_HOMEFOLDER);
                Map<String, Object> model = RhinoScriptService.buildDefaultModel(this.serviceRegistry, personRef, this.getCompanyHome(), homeSpaceRef, scriptRef, actionedUponNodeRef, spaceRef);
                this.serviceRegistry.getScriptService().executeScript(scriptRef, ContentModel.PROP_CONTENT, model);
            }
        }
    }

    @Override
    protected void addParameterDefinitions(List<ParameterDefinition> paramList) {
        paramList.add(new ParameterDefinitionImpl(PARAM_SCRIPTREF, DataTypeDefinition.NODE_REF, true, this.getParamDisplayLabel(PARAM_SCRIPTREF)));
        paramList.add(new ParameterDefinitionImpl(PARAM_SPACEREF, DataTypeDefinition.NODE_REF, false, this.getParamDisplayLabel(PARAM_SPACEREF)));
    }

    private NodeRef getCompanyHome() {
        List<NodeRef> refs = this.serviceRegistry.getSearchService().selectNodes(this.serviceRegistry.getNodeService().getRootNode(this.storeRef), this.companyHomePath, null, this.serviceRegistry.getNamespaceService(), false);
        if (refs.size() != 1) {
            throw new IllegalStateException("Invalid company home path: " + this.companyHomePath + " - found: " + refs.size());
        }
        NodeRef companyHomeRef = refs.get(0);
        return companyHomeRef;
    }
}

