/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.action.executer;

import java.util.List;
import org.alfresco.repo.action.ParameterDefinitionImpl;
import org.alfresco.repo.action.executer.ActionExecuterAbstractBase;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ParameterDefinition;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpecialiseTypeActionExecuter
extends ActionExecuterAbstractBase {
    public static final String NAME = "specialise-type";
    public static final String PARAM_TYPE_NAME = "type-name";
    private NodeService nodeService;
    private DictionaryService dictionaryService;

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    @Override
    public void executeImpl(Action ruleAction, NodeRef actionedUponNodeRef) {
        QName destinationType;
        QName currentType;
        if (this.nodeService.exists(actionedUponNodeRef) && !(currentType = this.nodeService.getType(actionedUponNodeRef)).equals(destinationType = (QName)ruleAction.getParameterValue(PARAM_TYPE_NAME)) && this.dictionaryService.isSubClass(destinationType, currentType)) {
            this.nodeService.setType(actionedUponNodeRef, destinationType);
        }
    }

    @Override
    protected void addParameterDefinitions(List<ParameterDefinition> paramList) {
        paramList.add(new ParameterDefinitionImpl(PARAM_TYPE_NAME, DataTypeDefinition.QNAME, true, this.getParamDisplayLabel(PARAM_TYPE_NAME)));
    }
}

