/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.action.executer;

import java.io.Serializable;
import java.util.List;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.action.ParameterDefinitionImpl;
import org.alfresco.repo.action.executer.ActionExecuterAbstractBase;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ParameterDefinition;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.CopyService;
import org.alfresco.service.cmr.repository.MimetypeService;
import org.alfresco.service.cmr.repository.NoTransformerException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.rule.RuleServiceException;
import org.alfresco.service.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransformActionExecuter
extends ActionExecuterAbstractBase {
    public static final String ERR_OVERWRITE = "Unable to overwrite copy because more than one have been found.";
    private static Log logger = LogFactory.getLog(TransformActionExecuter.class);
    public static final String NAME = "transform";
    public static final String PARAM_MIME_TYPE = "mime-type";
    public static final String PARAM_DESTINATION_FOLDER = "destination-folder";
    public static final String PARAM_ASSOC_TYPE_QNAME = "assoc-type";
    public static final String PARAM_ASSOC_QNAME = "assoc-name";
    public static final String PARAM_OVERWRITE_COPY = "overwrite-copy";
    private DictionaryService dictionaryService;
    private NodeService nodeService;
    private ContentService contentService;
    private CopyService copyService;
    private MimetypeService mimetypeService;

    public void setMimetypeService(MimetypeService mimetypeService) {
        this.mimetypeService = mimetypeService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    public void setCopyService(CopyService copyService) {
        this.copyService = copyService;
    }

    @Override
    protected void addParameterDefinitions(List<ParameterDefinition> paramList) {
        paramList.add(new ParameterDefinitionImpl(PARAM_MIME_TYPE, DataTypeDefinition.TEXT, true, this.getParamDisplayLabel(PARAM_MIME_TYPE)));
        paramList.add(new ParameterDefinitionImpl(PARAM_DESTINATION_FOLDER, DataTypeDefinition.NODE_REF, true, this.getParamDisplayLabel(PARAM_DESTINATION_FOLDER)));
        paramList.add(new ParameterDefinitionImpl(PARAM_ASSOC_TYPE_QNAME, DataTypeDefinition.QNAME, true, this.getParamDisplayLabel(PARAM_ASSOC_TYPE_QNAME)));
        paramList.add(new ParameterDefinitionImpl(PARAM_ASSOC_QNAME, DataTypeDefinition.QNAME, true, this.getParamDisplayLabel(PARAM_ASSOC_QNAME)));
        paramList.add(new ParameterDefinitionImpl(PARAM_OVERWRITE_COPY, DataTypeDefinition.BOOLEAN, false, this.getParamDisplayLabel(PARAM_OVERWRITE_COPY)));
    }

    @Override
    protected void executeImpl(Action ruleAction, NodeRef actionedUponNodeRef) {
        block12: {
            ContentReader contentReader;
            List<NodeRef> copies;
            if (!this.nodeService.exists(actionedUponNodeRef)) {
                return;
            }
            QName typeQName = this.nodeService.getType(actionedUponNodeRef);
            if (!this.dictionaryService.isSubClass(typeQName, ContentModel.TYPE_CONTENT)) {
                return;
            }
            String mimeType = (String)((Object)ruleAction.getParameterValue(PARAM_MIME_TYPE));
            NodeRef destinationParent = (NodeRef)ruleAction.getParameterValue(PARAM_DESTINATION_FOLDER);
            QName destinationAssocTypeQName = (QName)ruleAction.getParameterValue(PARAM_ASSOC_TYPE_QNAME);
            QName destinationAssocQName = (QName)ruleAction.getParameterValue(PARAM_ASSOC_QNAME);
            boolean overwrite = true;
            Boolean overwriteValue = (Boolean)ruleAction.getParameterValue(PARAM_OVERWRITE_COPY);
            if (overwriteValue != null) {
                overwrite = overwriteValue;
            }
            NodeRef copyNodeRef = null;
            if (overwrite && (copies = this.copyService.getCopies(actionedUponNodeRef)) != null && !copies.isEmpty()) {
                for (NodeRef copy : copies) {
                    NodeRef parent;
                    if (this.nodeService.hasAspect(copy, ContentModel.ASPECT_WORKING_COPY) || !(parent = this.nodeService.getPrimaryParent(copy).getParentRef()).equals(destinationParent)) continue;
                    if (copyNodeRef == null) {
                        copyNodeRef = copy;
                        continue;
                    }
                    throw new RuleServiceException(ERR_OVERWRITE);
                }
            }
            boolean newCopy = false;
            if (copyNodeRef == null) {
                copyNodeRef = this.copyService.copy(actionedUponNodeRef, destinationParent, destinationAssocTypeQName, destinationAssocQName, false);
                newCopy = true;
            }
            if ((contentReader = this.contentService.getReader(actionedUponNodeRef, ContentModel.PROP_CONTENT)) == null) {
                throw new AlfrescoRuntimeException("Attempting to execute content transformation rule but content has not finished writing, i.e. no URL is available.");
            }
            String originalMimetype = contentReader.getMimetype();
            ContentWriter contentWriter = this.contentService.getWriter(copyNodeRef, ContentModel.PROP_CONTENT, true);
            contentWriter.setMimetype(mimeType);
            contentWriter.setEncoding(contentReader.getEncoding());
            if (newCopy) {
                String originalName = (String)((Object)this.nodeService.getProperty(actionedUponNodeRef, ContentModel.PROP_NAME));
                String newName = this.transformName(originalName, originalMimetype, mimeType);
                this.nodeService.setProperty(copyNodeRef, ContentModel.PROP_NAME, (Serializable)((Object)newName));
                String originalTitle = (String)((Object)this.nodeService.getProperty(actionedUponNodeRef, ContentModel.PROP_TITLE));
                if (originalTitle != null && originalTitle.length() > 0) {
                    String newTitle = this.transformName(originalTitle, originalMimetype, mimeType);
                    this.nodeService.setProperty(copyNodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)newTitle));
                }
            }
            try {
                this.doTransform(ruleAction, contentReader, contentWriter);
            }
            catch (NoTransformerException e) {
                if (!logger.isDebugEnabled()) break block12;
                logger.debug((Object)("No transformer found to execute rule: \n   reader: " + contentReader + "\n" + "   writer: " + contentWriter + "\n" + "   action: " + this));
            }
        }
    }

    protected void doTransform(Action ruleAction, ContentReader contentReader, ContentWriter contentWriter) {
        this.contentService.transform(contentReader, contentWriter);
    }

    private String transformName(String original, String originalMimetype, String newMimetype) {
        int dotIndex = original.lastIndexOf(46);
        StringBuilder sb = new StringBuilder(original.length());
        if (dotIndex > -1) {
            sb.append(original.substring(0, dotIndex));
        } else {
            sb.append(original);
        }
        String newExtension = this.mimetypeService.getExtension(newMimetype);
        sb.append('.').append(newExtension);
        return sb.toString();
    }
}

