/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.action.scheduled;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.transaction.UserTransaction;
import junit.framework.TestCase;
import org.alfresco.repo.action.scheduled.FreeMarkerWithLuceneExtensionsModelFactory;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.datatype.Duration;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ApplicationContextHelper;
import org.alfresco.util.ISO8601DateFormat;
import org.springframework.context.ApplicationContext;

public class FreeMarkerModelLuceneFunctionTest
extends TestCase {
    private static SimpleDateFormat SDF2 = new SimpleDateFormat("yyyy-MM-dd");
    private static ApplicationContext ctx = ApplicationContextHelper.getApplicationContext();
    private AuthenticationComponent authenticationComponent;
    private ServiceRegistry serviceRegistry;
    private UserTransaction tx;
    private Date today;

    public FreeMarkerModelLuceneFunctionTest() {
    }

    public FreeMarkerModelLuceneFunctionTest(String arg0) {
        super(arg0);
    }

    public void setUp() throws Exception {
        this.authenticationComponent = (AuthenticationComponent)ctx.getBean("authenticationComponentImpl");
        this.serviceRegistry = (ServiceRegistry)ctx.getBean("ServiceRegistry");
        this.authenticationComponent.setSystemUserAsCurrentUser();
        TransactionService transactionService = (TransactionService)ctx.getBean(ServiceRegistry.TRANSACTION_SERVICE.getLocalName());
        this.tx = transactionService.getUserTransaction();
        this.tx.begin();
        GregorianCalendar cal = new GregorianCalendar();
        cal.set(10, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        this.today = cal.getTime();
    }

    protected void tearDown() throws Exception {
        this.authenticationComponent.clearCurrentSecurityContext();
        this.tx.rollback();
        super.tearDown();
    }

    public void testDate() {
        String template = "${date?date?string(\"yyyy-MM-dd\")}";
        FreeMarkerWithLuceneExtensionsModelFactory mf = new FreeMarkerWithLuceneExtensionsModelFactory();
        mf.setServiceRegistry(this.serviceRegistry);
        String result = this.serviceRegistry.getTemplateService().processTemplateString("freemarker", template, mf.getModel());
        FreeMarkerModelLuceneFunctionTest.assertEquals((String)result, (String)SDF2.format(new Date()));
    }

    public void testLuceneDateRangeFunction() {
        String template = "${luceneDateRange(\"2000-01-01T00:00:00.000Z\", \"P1D\")}";
        FreeMarkerWithLuceneExtensionsModelFactory mf = new FreeMarkerWithLuceneExtensionsModelFactory();
        mf.setServiceRegistry(this.serviceRegistry);
        String result = this.serviceRegistry.getTemplateService().processTemplateString("freemarker", template, mf.getModel());
        FreeMarkerModelLuceneFunctionTest.assertEquals((String)result, (String)"[2000-01-01T00:00:00.000Z TO 2000-01-02T00:00:00.000Z]");
    }

    public void testLuceneDateRangeFunctionToAdte() {
        String template = "${luceneDateRange(\"2000-01-01T00:00:00.000Z\", \"2000-01-05T00:00:00.000Z\")}";
        FreeMarkerWithLuceneExtensionsModelFactory mf = new FreeMarkerWithLuceneExtensionsModelFactory();
        mf.setServiceRegistry(this.serviceRegistry);
        String result = this.serviceRegistry.getTemplateService().processTemplateString("freemarker", template, mf.getModel());
        FreeMarkerModelLuceneFunctionTest.assertEquals((String)result, (String)"[2000-01-01T00:00:00.000Z TO 2000-01-05T00:00:00.000Z]");
    }

    public void testLuceneDateRangeFunctionTodayPlus4() {
        String template = "${luceneDateRange(today, \"P4D\")}";
        FreeMarkerWithLuceneExtensionsModelFactory mf = new FreeMarkerWithLuceneExtensionsModelFactory();
        mf.setServiceRegistry(this.serviceRegistry);
        String result = this.serviceRegistry.getTemplateService().processTemplateString("freemarker", template, mf.getModel());
        FreeMarkerModelLuceneFunctionTest.assertNotNull((Object)result);
        FreeMarkerModelLuceneFunctionTest.assertEquals((String)result, (String)("[" + ISO8601DateFormat.format((Date)this.today) + " TO " + ISO8601DateFormat.format((Date)Duration.add(this.today, new Duration("P4D"))) + "]"));
    }

    public void testLuceneDateRangeFunctionTodayMinus4() {
        String template = "${luceneDateRange(today, \"-P4D\")}";
        FreeMarkerWithLuceneExtensionsModelFactory mf = new FreeMarkerWithLuceneExtensionsModelFactory();
        mf.setServiceRegistry(this.serviceRegistry);
        String result = this.serviceRegistry.getTemplateService().processTemplateString("freemarker", template, mf.getModel());
        FreeMarkerModelLuceneFunctionTest.assertEquals((String)result, (String)("[" + ISO8601DateFormat.format((Date)Duration.add(this.today, new Duration("-P4D"))) + " TO " + ISO8601DateFormat.format((Date)this.today) + "]"));
    }

    public void testLuceneDateRangeFunctionTodayToday() {
        String template = "${luceneDateRange(today, today)}";
        FreeMarkerWithLuceneExtensionsModelFactory mf = new FreeMarkerWithLuceneExtensionsModelFactory();
        mf.setServiceRegistry(this.serviceRegistry);
        String result = this.serviceRegistry.getTemplateService().processTemplateString("freemarker", template, mf.getModel());
        FreeMarkerModelLuceneFunctionTest.assertEquals((String)result, (String)("[" + ISO8601DateFormat.format((Date)this.today) + " TO " + ISO8601DateFormat.format((Date)this.today) + "]"));
    }
}

