/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.admin.patch;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.List;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.admin.patch.Patch;
import org.alfresco.repo.admin.patch.PatchService;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.transaction.TransactionUtil;
import org.alfresco.service.cmr.admin.PatchException;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.transaction.TransactionService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPatch
implements Patch {
    public static final String ERR_PROPERTY_NOT_SET = "patch.general.property_not_set";
    private static Log logger = LogFactory.getLog(AbstractPatch.class);
    private String id;
    private int fixesFromSchema = -1;
    private int fixesToSchema = -1;
    private int targetSchema = -1;
    private String description;
    private List<Patch> dependsOn = Collections.emptyList();
    private boolean applied = false;
    private PatchService patchService;
    protected TransactionService transactionService;
    protected NamespaceService namespaceService;
    protected NodeService nodeService;
    protected SearchService searchService;
    protected AuthenticationComponent authenticationComponent;

    public String toString() {
        StringBuilder sb = new StringBuilder(256);
        sb.append("Patch").append("[ id=").append(this.id).append(", description=").append(this.description).append(", fixesFromSchema=").append(this.fixesFromSchema).append(", fixesToSchema=").append(this.fixesToSchema).append(", targetSchema=").append(this.targetSchema).append("]");
        return sb.toString();
    }

    public void setPatchService(PatchService patchService) {
        this.patchService = patchService;
    }

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    public void setNamespaceService(NamespaceService namespaceService) {
        this.namespaceService = namespaceService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }

    public void setAuthenticationComponent(AuthenticationComponent authenticationComponent) {
        this.authenticationComponent = authenticationComponent;
    }

    public void init() {
        if (this.patchService == null) {
            throw new AlfrescoRuntimeException("Mandatory property not set: patchService");
        }
        this.patchService.registerPatch(this);
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public int getFixesFromSchema() {
        return this.fixesFromSchema;
    }

    public void setFixesFromSchema(int version) {
        if (version < 0) {
            throw new IllegalArgumentException("The 'fixesFromSchema' property may not be less than 0");
        }
        this.fixesFromSchema = version;
        if (this.fixesToSchema < this.fixesFromSchema) {
            this.setFixesToSchema(this.fixesFromSchema);
        }
    }

    @Override
    public int getFixesToSchema() {
        return this.fixesToSchema;
    }

    public void setFixesToSchema(int version) {
        if (version < this.fixesFromSchema) {
            throw new IllegalArgumentException("'fixesToSchema' must be greater than or equal to 'fixesFromSchema'");
        }
        this.fixesToSchema = version;
    }

    @Override
    public int getTargetSchema() {
        return this.targetSchema;
    }

    public void setTargetSchema(int version) {
        if (version <= this.fixesToSchema) {
            throw new IllegalArgumentException("'targetSchema' must be greater than 'fixesToSchema'");
        }
        this.targetSchema = version;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public List<Patch> getDependsOn() {
        return this.dependsOn;
    }

    public void setDependsOn(List<Patch> dependsOn) {
        this.dependsOn = dependsOn;
    }

    @Override
    public boolean applies(int version) {
        return this.fixesFromSchema <= version && version <= this.fixesToSchema;
    }

    protected final void checkPropertyNotNull(Object value, String name) {
        if (value == null) {
            throw new PatchException(ERR_PROPERTY_NOT_SET, name, this);
        }
    }

    protected void checkProperties() {
        this.checkPropertyNotNull(this.id, "id");
        this.checkPropertyNotNull(this.description, "description");
        this.checkPropertyNotNull(this.transactionService, "transactionService");
        this.checkPropertyNotNull(this.namespaceService, "namespaceService");
        this.checkPropertyNotNull(this.nodeService, "nodeService");
        this.checkPropertyNotNull(this.searchService, "searchService");
        this.checkPropertyNotNull(this.authenticationComponent, "authenticationComponent");
        if (this.fixesFromSchema == -1 || this.fixesToSchema == -1 || this.targetSchema == -1) {
            throw new AlfrescoRuntimeException("Patch properties 'fixesFromSchema', 'fixesToSchema' and 'targetSchema' have not all been set on this patch: \n   patch: " + this);
        }
    }

    @Override
    public synchronized String apply() throws PatchException {
        if (this.applied) {
            throw new AlfrescoRuntimeException("The patch has already been executed: \n   patch: " + this);
        }
        this.checkProperties();
        try {
            TransactionUtil.TransactionWork<String> patchWork = new TransactionUtil.TransactionWork<String>(){

                @Override
                public String doWork() throws Exception {
                    String report = AbstractPatch.this.applyInternal();
                    return report;
                }
            };
            String report = TransactionUtil.executeInNonPropagatingUserTransaction(this.transactionService, patchWork);
            this.applied = true;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Patch successfully applied: \n   patch: " + this + "\n" + "   report: " + report));
            }
            return report;
        }
        catch (PatchException e) {
            throw e;
        }
        catch (Throwable e) {
            Throwable cause = e.getCause();
            if (cause != null && cause instanceof PatchException) {
                throw (PatchException)((Object)cause);
            }
            String report = this.makeReport(e);
            throw new PatchException(report);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String makeReport(Throwable e) {
        StringWriter stringWriter = new StringWriter(1024);
        PrintWriter printWriter = new PrintWriter((Writer)stringWriter, true);
        try {
            e.printStackTrace(printWriter);
            String string = stringWriter.toString();
            return string;
        }
        finally {
            printWriter.close();
        }
    }

    protected abstract String applyInternal() throws Exception;
}

