/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.admin.patch;

import java.util.Date;
import java.util.List;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.i18n.I18NUtil;
import org.alfresco.repo.admin.patch.PatchInfo;
import org.alfresco.repo.admin.patch.PatchService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;

public class PatchExecuter
implements ApplicationListener {
    private static final String MSG_CHECKING = "patch.executer.checking";
    private static final String MSG_NO_PATCHES_REQUIRED = "patch.executer.no_patches_required";
    private static final String MSG_NOT_EXECUTED = "patch.executer.not_executed";
    private static final String MSG_EXECUTED = "patch.executer.executed";
    private static final String MSG_FAILED = "patch.executer.failed";
    private static Log logger = LogFactory.getLog(PatchExecuter.class);
    private PatchService patchService;

    public void setPatchService(PatchService patchService) {
        this.patchService = patchService;
    }

    public void applyOutstandingPatches() {
        logger.info((Object)I18NUtil.getMessage((String)MSG_CHECKING));
        Date before = new Date(System.currentTimeMillis() - 20000L);
        this.patchService.applyOutstandingPatches();
        Date after = new Date(System.currentTimeMillis() + 20000L);
        List<PatchInfo> appliedPatches = this.patchService.getPatches(before, after);
        if (appliedPatches.size() == 0) {
            logger.info((Object)I18NUtil.getMessage((String)MSG_NO_PATCHES_REQUIRED));
        } else {
            boolean succeeded = true;
            for (PatchInfo patchInfo : appliedPatches) {
                if (!patchInfo.getWasExecuted()) {
                    logger.debug((Object)I18NUtil.getMessage((String)MSG_NOT_EXECUTED, (Object[])new Object[]{patchInfo.getId(), patchInfo.getReport()}));
                    continue;
                }
                if (patchInfo.getSucceeded()) {
                    logger.info((Object)I18NUtil.getMessage((String)MSG_EXECUTED, (Object[])new Object[]{patchInfo.getId(), patchInfo.getReport()}));
                    continue;
                }
                succeeded = false;
                logger.error((Object)I18NUtil.getMessage((String)MSG_FAILED, (Object[])new Object[]{patchInfo.getId(), patchInfo.getReport()}));
            }
            if (!succeeded) {
                throw new AlfrescoRuntimeException("Not all patches could be applied");
            }
        }
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof ContextRefreshedEvent) {
            this.applyOutstandingPatches();
        }
    }
}

