/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.admin.patch;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.alfresco.i18n.I18NUtil;
import org.alfresco.repo.admin.patch.Patch;
import org.alfresco.repo.admin.patch.PatchDaoService;
import org.alfresco.repo.admin.patch.PatchInfo;
import org.alfresco.repo.admin.patch.PatchService;
import org.alfresco.repo.domain.AppliedPatch;
import org.alfresco.service.cmr.admin.PatchException;
import org.alfresco.service.descriptor.Descriptor;
import org.alfresco.service.descriptor.DescriptorService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PatchServiceImpl
implements PatchService {
    private static final String MSG_NOT_RELEVANT = "patch.service.not_relevant";
    private static final Date ZERO_DATE = new Date(0L);
    private static final Date INFINITE_DATE = new Date(Long.MAX_VALUE);
    private static Log logger = LogFactory.getLog(PatchServiceImpl.class);
    private DescriptorService descriptorService;
    private PatchDaoService patchDaoService;
    private List<Patch> patches = new ArrayList<Patch>(10);

    public void setDescriptorService(DescriptorService descriptorService) {
        this.descriptorService = descriptorService;
    }

    public void setPatchDaoService(PatchDaoService patchDaoService) {
        this.patchDaoService = patchDaoService;
    }

    @Override
    public void registerPatch(Patch patch) {
        this.patches.add(patch);
    }

    @Override
    public boolean applyOutstandingPatches() {
        Patch patch;
        HashMap<String, Patch> allPatchesById = new HashMap<String, Patch>(23);
        for (Patch patch2 : this.patches) {
            allPatchesById.put(patch2.getId(), patch2);
        }
        HashMap<String, AppliedPatch> appliedPatchesById = new HashMap<String, AppliedPatch>(23);
        List<AppliedPatch> appliedPatches = this.patchDaoService.getAppliedPatches();
        for (AppliedPatch appliedPatch : appliedPatches) {
            appliedPatchesById.put(appliedPatch.getId(), appliedPatch);
        }
        boolean success = true;
        Iterator i$ = allPatchesById.values().iterator();
        while (i$.hasNext() && (success = this.applyPatchAndDependencies(patch = (Patch)i$.next(), appliedPatchesById))) {
        }
        return success;
    }

    private boolean applyPatchAndDependencies(Patch patch, Map<String, AppliedPatch> appliedPatchesById) {
        String id = patch.getId();
        AppliedPatch appliedPatch = appliedPatchesById.get(id);
        if (appliedPatch != null && appliedPatch.getSucceeded()) {
            return true;
        }
        List<Patch> dependencies = patch.getDependsOn();
        for (Patch dependencyPatch : dependencies) {
            boolean success = this.applyPatchAndDependencies(dependencyPatch, appliedPatchesById);
            if (success) continue;
            return false;
        }
        appliedPatch = this.applyPatch(patch);
        if (!appliedPatch.getSucceeded()) {
            return false;
        }
        appliedPatchesById.put(id, appliedPatch);
        return true;
    }

    private AppliedPatch applyPatch(Patch patch) {
        String patchDescription;
        AppliedPatch appliedPatch = this.patchDaoService.getAppliedPatch(patch.getId());
        if (appliedPatch != null && appliedPatch.getSucceeded()) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Patch was already successfully applied: \n   patch: " + appliedPatch));
            }
            return appliedPatch;
        }
        String report = null;
        boolean success = false;
        Descriptor repoDescriptor = this.descriptorService.getInstalledRepositoryDescriptor();
        boolean applies = this.applies(repoDescriptor, patch);
        if (!applies) {
            report = I18NUtil.getMessage((String)MSG_NOT_RELEVANT, (Object[])new Object[]{repoDescriptor.getSchema()});
            success = true;
        } else {
            try {
                report = patch.apply();
                success = true;
            }
            catch (PatchException e) {
                report = e.getMessage();
                success = false;
                logger.error((Object)report);
            }
        }
        Descriptor serverDescriptor = this.descriptorService.getServerDescriptor();
        String server = serverDescriptor.getVersion() + " - " + serverDescriptor.getEdition();
        if (appliedPatch == null) {
            appliedPatch = this.patchDaoService.newAppliedPatch(patch.getId());
        }
        if ((patchDescription = I18NUtil.getMessage((String)patch.getDescription())) == null) {
            logger.warn((Object)("Patch description is not available: " + patch));
            patchDescription = "No patch description available";
        }
        appliedPatch.setDescription(patchDescription);
        appliedPatch.setFixesFromSchema(patch.getFixesFromSchema());
        appliedPatch.setFixesToSchema(patch.getFixesToSchema());
        appliedPatch.setTargetSchema(patch.getTargetSchema());
        appliedPatch.setAppliedToSchema(repoDescriptor.getSchema());
        appliedPatch.setAppliedToServer(server);
        appliedPatch.setAppliedOnDate(new Date());
        appliedPatch.setSucceeded(success);
        appliedPatch.setWasExecuted(applies);
        appliedPatch.setReport(report);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Applied patch: \n" + appliedPatch));
        }
        return appliedPatch;
    }

    private boolean applies(Descriptor repoDescriptor, Patch patch) {
        int repoSchema = repoDescriptor.getSchema();
        boolean apply = patch.applies(repoSchema);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Patch schema version number check against repo version: \n   repo schema version: " + repoDescriptor.getVersion() + "\n" + "   patch: " + patch));
        }
        return apply;
    }

    @Override
    public List<PatchInfo> getPatches(Date fromDate, Date toDate) {
        if (fromDate == null) {
            fromDate = ZERO_DATE;
        }
        if (toDate == null) {
            toDate = INFINITE_DATE;
        }
        List<PatchInfo> appliedPatches = this.patchDaoService.getAppliedPatches(fromDate, toDate);
        for (PatchInfo appliedPatch : appliedPatches) {
            this.patchDaoService.detach((AppliedPatch)appliedPatch);
        }
        return appliedPatches;
    }
}

