/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.admin.patch.hibernate;

import java.io.Serializable;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.admin.patch.PatchDaoService;
import org.alfresco.repo.domain.AppliedPatch;
import org.alfresco.repo.domain.hibernate.AppliedPatchImpl;
import org.hibernate.Query;
import org.hibernate.Session;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HibernatePatchDaoServiceImpl
extends HibernateDaoSupport
implements PatchDaoService {
    public static final String QUERY_GET_ALL_APPLIED_PATCHES = "patch.GetAllAppliedPatches";
    public static final String QUERY_GET_APPLIED_PATCHES_BY_DATE = "patch.GetAppliedPatchesByDate";

    @Override
    public AppliedPatch newAppliedPatch(String id) {
        AppliedPatch existing = this.getAppliedPatch(id);
        if (existing != null) {
            throw new AlfrescoRuntimeException("An applied patch already exists: \n   id: " + id);
        }
        AppliedPatchImpl patch = new AppliedPatchImpl();
        patch.setId(id);
        this.getHibernateTemplate().save((Object)patch);
        return patch;
    }

    @Override
    public AppliedPatch getAppliedPatch(String id) {
        AppliedPatch patch = (AppliedPatch)this.getHibernateTemplate().get(AppliedPatchImpl.class, (Serializable)((Object)id));
        return patch;
    }

    @Override
    public void detach(AppliedPatch appliedPatch) {
        this.getSession().evict((Object)appliedPatch);
    }

    @Override
    public List<AppliedPatch> getAppliedPatches() {
        HibernateCallback callback = new HibernateCallback(){

            public Object doInHibernate(Session session) {
                Query query = session.getNamedQuery(HibernatePatchDaoServiceImpl.QUERY_GET_ALL_APPLIED_PATCHES);
                return query.list();
            }
        };
        List queryResults = (List)this.getHibernateTemplate().execute(callback);
        return queryResults;
    }

    @Override
    public List<AppliedPatch> getAppliedPatches(Date fromDate, Date toDate) {
        HibernateCallback callback = new HibernateCallback(){

            public Object doInHibernate(Session session) {
                Query query = session.getNamedQuery(HibernatePatchDaoServiceImpl.QUERY_GET_ALL_APPLIED_PATCHES);
                return query.list();
            }
        };
        List queryResults = (List)this.getHibernateTemplate().execute(callback);
        Iterator iterator = queryResults.iterator();
        while (iterator.hasNext()) {
            AppliedPatch appliedPatch = (AppliedPatch)iterator.next();
            Date appliedOnDate = appliedPatch.getAppliedOnDate();
            if (fromDate.compareTo(appliedOnDate) < 0 && toDate.compareTo(appliedOnDate) > 0) continue;
            iterator.remove();
        }
        return queryResults;
    }
}

