/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.admin.patch.impl;

import java.util.List;
import org.alfresco.i18n.I18NUtil;
import org.alfresco.repo.admin.patch.AbstractPatch;
import org.alfresco.repo.importer.ImporterBootstrap;
import org.alfresco.service.cmr.admin.PatchException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.namespace.NamespaceService;

public class CategoryRootPermissionPatch
extends AbstractPatch {
    private static final String MSG_RESULT = "patch.categoryRootPermission.result";
    private static final String ERR_NOT_FOUND = "patch.categoryRootPermission.err.not_found";
    private PermissionService permissionService;
    private ImporterBootstrap spacesBootstrap;
    private SearchService searchService;
    private NamespaceService namespaceService;
    private NodeService nodeService;

    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }

    public void setSpacesBootstrap(ImporterBootstrap spacesBootstrap) {
        this.spacesBootstrap = spacesBootstrap;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }

    public void setNamespaceService(NamespaceService namespaceService) {
        this.namespaceService = namespaceService;
    }

    protected String applyInternal() throws Exception {
        String categoryRootPath = "/cm:categoryRoot";
        NodeRef rootNodeRef = this.nodeService.getRootNode(this.spacesBootstrap.getStoreRef());
        List<NodeRef> nodeRefs = this.searchService.selectNodes(rootNodeRef, categoryRootPath, null, this.namespaceService, false);
        if (nodeRefs.size() == 0) {
            String msg = I18NUtil.getMessage((String)ERR_NOT_FOUND, (Object[])new Object[]{categoryRootPath});
            throw new PatchException(msg);
        }
        NodeRef categoryRootRef = nodeRefs.get(0);
        this.permissionService.setPermission(categoryRootRef, "guest", "Read", true);
        String msg = I18NUtil.getMessage((String)MSG_RESULT, (Object[])new Object[]{categoryRootPath});
        return msg;
    }
}

