/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.admin.patch.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.alfresco.i18n.I18NUtil;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.admin.patch.AbstractPatch;
import org.alfresco.repo.importer.ImporterBootstrap;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;

public class DescriptorUpdatePatch
extends AbstractPatch {
    private static final String MSG_SUCCESS = "patch.descriptorUpdate.result";
    private ImporterBootstrap systemBootstrap;

    public void setSystemBootstrap(ImporterBootstrap systemBootstrap) {
        this.systemBootstrap = systemBootstrap;
    }

    protected String applyInternal() throws Exception {
        this.checkPropertyNotNull(this.systemBootstrap, "systemBootstrap");
        StoreRef storeRef = this.systemBootstrap.getStoreRef();
        Properties systemProperties = this.systemBootstrap.getConfiguration();
        if (this.nodeService.exists(storeRef)) {
            NodeRef descriptorNodeRef;
            Serializable value;
            String path = systemProperties.getProperty("system.descriptor.current.childname");
            String searchPath = "/" + path;
            NodeRef rootNodeRef = this.nodeService.getRootNode(storeRef);
            List<NodeRef> nodeRefs = this.searchService.selectNodes(rootNodeRef, searchPath, null, this.namespaceService, false);
            if (nodeRefs.size() > 0 && (value = this.nodeService.getProperty(descriptorNodeRef = nodeRefs.get(0), ContentModel.PROP_SYS_VERSION_EDITION)) == null) {
                String edition = systemProperties.getProperty("version.edition");
                ArrayList<String> editions = new ArrayList<String>();
                editions.add(edition);
                this.nodeService.setProperty(descriptorNodeRef, ContentModel.PROP_SYS_VERSION_EDITION, editions);
            }
        }
        String msg = I18NUtil.getMessage((String)MSG_SUCCESS);
        return msg;
    }
}

