/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.admin.patch.impl;

import java.io.IOException;
import java.util.List;
import java.util.Properties;
import org.alfresco.i18n.I18NUtil;
import org.alfresco.repo.admin.patch.AbstractPatch;
import org.alfresco.repo.importer.ACPImportPackageHandler;
import org.alfresco.repo.importer.ImporterBootstrap;
import org.alfresco.service.cmr.admin.PatchException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.view.ImporterService;
import org.alfresco.service.cmr.view.Location;
import org.springframework.context.MessageSource;
import org.springframework.core.io.ClassPathResource;

public class EmailTemplatesContentPatch
extends AbstractPatch {
    private static final String MSG_CREATED = "patch.emailTemplatesContent.result";
    public static final String PROPERTY_COMPANY_HOME_CHILDNAME = "spaces.company_home.childname";
    public static final String PROPERTY_DICTIONARY_CHILDNAME = "spaces.dictionary.childname";
    public static final String PROPERTY_EMAIL_TEMPLATES_CHILDNAME = "spaces.templates.email.childname";
    private ImporterBootstrap importerBootstrap;
    private ImporterService importerService;
    private MessageSource messageSource;
    protected Properties configuration;
    protected NodeRef emailTemplatesNodeRef;
    private String templatesACP;

    public void setImporterBootstrap(ImporterBootstrap importerBootstrap) {
        this.importerBootstrap = importerBootstrap;
    }

    public void setImporterService(ImporterService importerService) {
        this.importerService = importerService;
    }

    public void setMessageSource(MessageSource messageSource) {
        this.messageSource = messageSource;
    }

    public void setTemplatesACP(String templatesACP) {
        this.templatesACP = templatesACP;
    }

    protected void checkRequiredProperties() throws Exception {
        this.checkPropertyNotNull(this.importerBootstrap, "importerBootstrap");
        this.checkPropertyNotNull(this.importerService, "importerService");
        this.checkPropertyNotNull(this.messageSource, "messageSource");
        this.checkPropertyNotNull(this.templatesACP, "templatesACP");
    }

    protected void setUp() throws Exception {
        StoreRef storeRef = this.importerBootstrap.getStoreRef();
        if (storeRef == null) {
            throw new PatchException("Bootstrap store has not been set");
        }
        NodeRef storeRootNodeRef = this.nodeService.getRootNode(storeRef);
        this.configuration = this.importerBootstrap.getConfiguration();
        String companyHomeChildName = this.configuration.getProperty(PROPERTY_COMPANY_HOME_CHILDNAME);
        if (companyHomeChildName == null || companyHomeChildName.length() == 0) {
            throw new PatchException("Bootstrap property 'spaces.company_home.childname' is not present");
        }
        String dictionaryChildName = this.configuration.getProperty(PROPERTY_DICTIONARY_CHILDNAME);
        if (dictionaryChildName == null || dictionaryChildName.length() == 0) {
            throw new PatchException("Bootstrap property 'spaces.dictionary.childname' is not present");
        }
        String emailTemplatesChildName = this.configuration.getProperty(PROPERTY_EMAIL_TEMPLATES_CHILDNAME);
        if (emailTemplatesChildName == null || emailTemplatesChildName.length() == 0) {
            throw new PatchException("Bootstrap property 'spaces.templates.email.childname' is not present");
        }
        StringBuilder sb = new StringBuilder(128);
        sb.append("/").append(companyHomeChildName).append("/").append(dictionaryChildName).append("/").append(emailTemplatesChildName);
        String xpath = sb.toString();
        List<NodeRef> nodeRefs = this.searchService.selectNodes(storeRootNodeRef, xpath, null, this.namespaceService, false);
        if (nodeRefs.size() == 0) {
            throw new PatchException("Unable to locate Email Templates folder: \n   root: " + storeRootNodeRef + "\n" + "   xpath: " + xpath);
        }
        if (nodeRefs.size() > 1) {
            throw new PatchException("Found too many Email Templates folder results: \n   root: " + storeRootNodeRef + "\n" + "   xpath: " + xpath + "\n" + "   results: " + nodeRefs);
        }
        this.emailTemplatesNodeRef = nodeRefs.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String applyInternal() throws Exception {
        this.checkRequiredProperties();
        this.setUp();
        try {
            this.authenticationComponent.setCurrentUser(this.authenticationComponent.getSystemUserName());
            this.importContent();
        }
        finally {
            this.authenticationComponent.clearCurrentSecurityContext();
        }
        return I18NUtil.getMessage((String)MSG_CREATED);
    }

    private void importContent() throws IOException {
        ClassPathResource acpResource = new ClassPathResource(this.templatesACP);
        ACPImportPackageHandler acpHandler = new ACPImportPackageHandler(acpResource.getFile(), null);
        Location importLocation = new Location(this.emailTemplatesNodeRef);
        this.importerService.importView(acpHandler, importLocation, null, null);
    }
}

