/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.admin.patch.impl;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.alfresco.i18n.I18NUtil;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.admin.patch.AbstractPatch;
import org.alfresco.repo.importer.ImporterBootstrap;
import org.alfresco.service.cmr.admin.PatchException;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.namespace.QName;
import org.springframework.context.MessageSource;

public class EmailTemplatesFolderPatch
extends AbstractPatch {
    private static final String MSG_EXISTS = "patch.emailTemplatesFolder.result.exists";
    private static final String MSG_CREATED = "patch.emailTemplatesFolder.result.created";
    public static final String PROPERTY_COMPANY_HOME_CHILDNAME = "spaces.company_home.childname";
    public static final String PROPERTY_DICTIONARY_CHILDNAME = "spaces.dictionary.childname";
    public static final String PROPERTY_EMAIL_TEMPLATES_FOLDER_CHILDNAME = "spaces.templates.email.childname";
    private static final String PROPERTY_EMAIL_TEMPLATES_FOLDER_NAME = "spaces.templates.email.name";
    private static final String PROPERTY_EMAIL_TEMPLATES_FOLDER_DESCRIPTION = "spaces.templates.email.description";
    private static final String PROPERTY_ICON = "space-icon-default";
    private ImporterBootstrap importerBootstrap;
    private MessageSource messageSource;
    protected NodeRef dictionaryNodeRef;
    protected Properties configuration;
    protected NodeRef emailTemplatesFolderNodeRef;

    public void setImporterBootstrap(ImporterBootstrap importerBootstrap) {
        this.importerBootstrap = importerBootstrap;
    }

    public void setMessageSource(MessageSource messageSource) {
        this.messageSource = messageSource;
    }

    protected void checkCommonProperties() throws Exception {
        this.checkPropertyNotNull(this.importerBootstrap, "importerBootstrap");
        this.checkPropertyNotNull(this.messageSource, "messageSource");
    }

    protected void setUp() throws Exception {
        StoreRef storeRef = this.importerBootstrap.getStoreRef();
        if (storeRef == null) {
            throw new PatchException("Bootstrap store has not been set");
        }
        NodeRef storeRootNodeRef = this.nodeService.getRootNode(storeRef);
        this.configuration = this.importerBootstrap.getConfiguration();
        String companyHomeChildName = this.configuration.getProperty(PROPERTY_COMPANY_HOME_CHILDNAME);
        if (companyHomeChildName == null || companyHomeChildName.length() == 0) {
            throw new PatchException("Bootstrap property 'spaces.company_home.childname' is not present");
        }
        String dictionaryChildName = this.configuration.getProperty(PROPERTY_DICTIONARY_CHILDNAME);
        if (dictionaryChildName == null || dictionaryChildName.length() == 0) {
            throw new PatchException("Bootstrap property 'spaces.dictionary.childname' is not present");
        }
        String emailTemplatesChildName = this.configuration.getProperty(PROPERTY_EMAIL_TEMPLATES_FOLDER_CHILDNAME);
        if (emailTemplatesChildName == null || emailTemplatesChildName.length() == 0) {
            throw new PatchException("Bootstrap property 'spaces.templates.email.childname' is not present");
        }
        StringBuilder sb = new StringBuilder(128);
        sb.append("/").append(companyHomeChildName).append("/").append(dictionaryChildName);
        String xpath = sb.toString();
        List<NodeRef> nodeRefs = this.searchService.selectNodes(storeRootNodeRef, xpath, null, this.namespaceService, false);
        if (nodeRefs.size() == 0) {
            throw new PatchException("XPath didn't return any results: \n   root: " + storeRootNodeRef + "\n" + "   xpath: " + xpath);
        }
        if (nodeRefs.size() > 1) {
            throw new PatchException("XPath returned too many results: \n   root: " + storeRootNodeRef + "\n" + "   xpath: " + xpath + "\n" + "   results: " + nodeRefs);
        }
        this.dictionaryNodeRef = nodeRefs.get(0);
        xpath = emailTemplatesChildName;
        nodeRefs = this.searchService.selectNodes(this.dictionaryNodeRef, xpath, null, this.namespaceService, false);
        if (nodeRefs.size() > 1) {
            throw new PatchException("XPath returned too many results: \n   dictionary node: " + this.dictionaryNodeRef + "\n" + "   xpath: " + xpath + "\n" + "   results: " + nodeRefs);
        }
        this.emailTemplatesFolderNodeRef = nodeRefs.size() == 0 ? null : nodeRefs.get(0);
    }

    protected String applyInternal() throws Exception {
        this.checkCommonProperties();
        if (this.messageSource == null) {
            throw new PatchException("'messageSource' property has not been set");
        }
        this.setUp();
        String msg = null;
        if (this.emailTemplatesFolderNodeRef == null) {
            this.createFolder();
            msg = I18NUtil.getMessage((String)MSG_CREATED, (Object[])new Object[]{this.emailTemplatesFolderNodeRef});
        } else {
            msg = I18NUtil.getMessage((String)MSG_EXISTS, (Object[])new Object[]{this.emailTemplatesFolderNodeRef});
        }
        return msg;
    }

    private void createFolder() {
        String emailTemplatesChildName = this.configuration.getProperty(PROPERTY_EMAIL_TEMPLATES_FOLDER_CHILDNAME);
        if (emailTemplatesChildName == null) {
            throw new PatchException("Bootstrap property 'spaces.templates.email.childname' is not present");
        }
        String emailTemplatesName = this.messageSource.getMessage(PROPERTY_EMAIL_TEMPLATES_FOLDER_NAME, null, I18NUtil.getLocale());
        if (emailTemplatesName == null || emailTemplatesName.length() == 0) {
            throw new PatchException("Bootstrap property 'spaces.templates.email.name' is not present");
        }
        String emailTemplatesDescription = this.messageSource.getMessage(PROPERTY_EMAIL_TEMPLATES_FOLDER_DESCRIPTION, null, I18NUtil.getLocale());
        if (emailTemplatesDescription == null || emailTemplatesDescription.length() == 0) {
            throw new PatchException("Bootstrap property 'spaces.templates.email.description' is not present");
        }
        HashMap<QName, Serializable> properties = new HashMap<QName, Serializable>(7);
        properties.put(ContentModel.PROP_NAME, (Serializable)((Object)emailTemplatesName));
        properties.put(ContentModel.PROP_TITLE, (Serializable)((Object)emailTemplatesName));
        properties.put(ContentModel.PROP_DESCRIPTION, (Serializable)((Object)emailTemplatesDescription));
        properties.put(ContentModel.PROP_ICON, (Serializable)((Object)PROPERTY_ICON));
        ChildAssociationRef childAssocRef = this.nodeService.createNode(this.dictionaryNodeRef, ContentModel.ASSOC_CONTAINS, QName.resolveToQName(this.namespaceService, emailTemplatesChildName), ContentModel.TYPE_FOLDER, properties);
        this.emailTemplatesFolderNodeRef = childAssocRef.getChildRef();
        this.nodeService.addAspect(this.emailTemplatesFolderNodeRef, ContentModel.ASPECT_UIFACETS, null);
    }
}

