/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.admin.patch.impl;

import java.io.Serializable;
import org.alfresco.i18n.I18NUtil;
import org.alfresco.model.ContentModel;
import org.alfresco.model.ForumModel;
import org.alfresco.repo.admin.patch.AbstractPatch;
import org.alfresco.repo.importer.ImporterBootstrap;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.namespace.QName;

public class ForumsIconsPatch
extends AbstractPatch {
    private static final String MSG_SUCCESS = "patch.forumsIcons.result";
    private ImporterBootstrap importerBootstrap;

    public void setImporterBootstrap(ImporterBootstrap importerBootstrap) {
        this.importerBootstrap = importerBootstrap;
    }

    protected String applyInternal() throws Exception {
        int iconsChanged = 0;
        iconsChanged += this.changeIcons(ForumModel.TYPE_FORUMS);
        iconsChanged += this.changeIcons(ForumModel.TYPE_FORUM);
        return I18NUtil.getMessage((String)MSG_SUCCESS, (Object[])new Object[]{iconsChanged += this.changeIcons(ForumModel.TYPE_TOPIC)});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int changeIcons(QName typeName) {
        int changed = 0;
        String query = "TYPE:\"" + typeName.toString() + "\"";
        ResultSet results = null;
        try {
            results = this.searchService.query(this.importerBootstrap.getStoreRef(), "lucene", query);
            if (results.length() > 0) {
                for (NodeRef node : results.getNodeRefs()) {
                    int idx;
                    String icon;
                    if (!this.nodeService.exists(node) || (icon = (String)((Object)this.nodeService.getProperty(node, ContentModel.PROP_ICON))) == null || icon.length() <= 0 || (idx = icon.indexOf("_large")) == -1) continue;
                    String newIcon = icon.substring(0, idx);
                    this.nodeService.setProperty(node, ContentModel.PROP_ICON, (Serializable)((Object)newIcon));
                    ++changed;
                }
            }
        }
        finally {
            if (results != null) {
                results.close();
            }
        }
        return changed;
    }
}

