/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.admin.patch.impl;

import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.alfresco.i18n.I18NUtil;
import org.alfresco.repo.admin.patch.AbstractPatch;
import org.alfresco.repo.importer.ImporterBootstrap;
import org.alfresco.service.cmr.admin.PatchException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;

public class GenericBootstrapPatch
extends AbstractPatch {
    private static final String MSG_EXISTS = "patch.genericBootstrap.result.exists";
    private static final String MSG_CREATED = "patch.genericBootstrap.result.created";
    private static final String ERR_MULTIPLE_FOUND = "patch.genericBootstrap.err.multiple_found";
    private ImporterBootstrap importerBootstrap;
    private String checkPath;
    private Properties bootstrapView;

    public void setImporterBootstrap(ImporterBootstrap importerBootstrap) {
        this.importerBootstrap = importerBootstrap;
    }

    public void setCheckPath(String checkPath) {
        this.checkPath = checkPath;
    }

    public void setBootstrapView(Properties bootstrapView) {
        this.bootstrapView = bootstrapView;
    }

    protected void checkProperties() {
        this.checkPropertyNotNull(this.importerBootstrap, "importerBootstrap");
        this.checkPropertyNotNull(this.checkPath, "checkPath");
        this.checkPropertyNotNull(this.bootstrapView, "bootstrapView");
        super.checkProperties();
    }

    protected String applyInternal() throws Exception {
        StoreRef storeRef = this.importerBootstrap.getStoreRef();
        NodeRef rootNodeRef = this.nodeService.getRootNode(storeRef);
        List<NodeRef> results = this.searchService.selectNodes(rootNodeRef, this.checkPath, null, this.namespaceService, false);
        if (results.size() > 1) {
            throw new PatchException(ERR_MULTIPLE_FOUND, this.checkPath);
        }
        if (results.size() == 1) {
            return I18NUtil.getMessage((String)MSG_EXISTS, (Object[])new Object[]{this.checkPath});
        }
        String path = this.bootstrapView.getProperty("path");
        List<Properties> bootstrapViews = Collections.singletonList(this.bootstrapView);
        this.importerBootstrap.setBootstrapViews(bootstrapViews);
        this.importerBootstrap.setUseExistingStore(true);
        this.importerBootstrap.bootstrap();
        return I18NUtil.getMessage((String)MSG_CREATED, (Object[])new Object[]{path, rootNodeRef});
    }
}

