/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.admin.patch.impl;

import org.alfresco.i18n.I18NUtil;
import org.alfresco.repo.admin.patch.AbstractPatch;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.cmr.security.PersonService;

public class GuestPersonPermissionPatch
extends AbstractPatch {
    private static final String MSG_SUCCESS = "patch.guestPersonPermission.result";
    private PersonService personService;
    private PermissionService permissionService;
    private String guestId = "guest";

    public void setGuestId(String guestId) {
        this.guestId = guestId;
    }

    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    protected String applyInternal() throws Exception {
        if (this.personService.personExists(this.guestId)) {
            NodeRef personRef = this.personService.getPerson(this.guestId);
            this.permissionService.setInheritParentPermissions(personRef, false);
            this.permissionService.deletePermission(personRef, this.guestId, "Consumer");
            this.permissionService.setPermission(personRef, this.guestId, "Read", true);
        }
        return I18NUtil.getMessage((String)MSG_SUCCESS);
    }
}

