/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.admin.patch.impl;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.alfresco.i18n.I18NUtil;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.admin.patch.AbstractPatch;
import org.alfresco.repo.importer.ImporterBootstrap;
import org.alfresco.service.cmr.admin.PatchException;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.springframework.context.MessageSource;

public class GuestUserPatch
extends AbstractPatch {
    private static final String MSG_SUCCESS = "patch.guestUser.result";
    private static final String COMPANY_HOME_CHILD_NAME = "spaces.company_home.childname";
    private static final String GUEST_HOME_CHILD_NAME = "spaces.guest_home.childname";
    private static final String GUEST_HOME_NAME = "spaces.guest_home.name";
    private static final String GUEST_HOME_DESCRIPTION = "spaces.guest_home.description";
    private PersonService personService;
    private NodeService nodeService;
    private SearchService searchService;
    private PermissionService permissionService;
    private ImporterBootstrap importerBootstrap;
    private NamespaceService namespaceService;
    private String guestId = "guest";
    private MessageSource messageSource;

    public void setGuestId(String guestId) {
        this.guestId = guestId;
    }

    public void setImporterBootstrap(ImporterBootstrap importerBootstrap) {
        this.importerBootstrap = importerBootstrap;
    }

    public void setNamespaceService(NamespaceService namespaceService) {
        this.namespaceService = namespaceService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    public void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }

    public void setMessageSource(MessageSource messageSource) {
        this.messageSource = messageSource;
    }

    protected String applyInternal() throws Exception {
        StoreRef storeRef = this.importerBootstrap.getStoreRef();
        if (storeRef == null) {
            throw new PatchException("Bootstrap store has not been set");
        }
        NodeRef storeRootNodeRef = this.nodeService.getRootNode(storeRef);
        Properties configuration = this.importerBootstrap.getConfiguration();
        String companyHomeChildName = configuration.getProperty(COMPANY_HOME_CHILD_NAME);
        if (companyHomeChildName == null || companyHomeChildName.length() == 0) {
            throw new PatchException("Bootstrap property 'spaces.company_home.childname' is not present");
        }
        String guestHomeChildName = configuration.getProperty(GUEST_HOME_CHILD_NAME);
        if (guestHomeChildName == null || guestHomeChildName.length() == 0) {
            throw new PatchException("Bootstrap property 'spaces.guest_home.childname' is not present");
        }
        NodeRef companyHomeRef = this.setCompanyHomeSpacePermissions(storeRootNodeRef, companyHomeChildName);
        NodeRef guestHomeRef = this.addGuestHomeSpace(storeRootNodeRef, configuration, companyHomeChildName, guestHomeChildName, companyHomeRef);
        this.addGuestUser(guestHomeRef);
        return I18NUtil.getMessage((String)MSG_SUCCESS);
    }

    private void addGuestUser(NodeRef guestHomeRef) {
        if (!this.personService.personExists(this.guestId)) {
            HashMap<QName, Serializable> properties = new HashMap<QName, Serializable>();
            properties.put(ContentModel.PROP_USERNAME, (Serializable)((Object)this.guestId));
            properties.put(ContentModel.PROP_HOMEFOLDER, guestHomeRef);
            properties.put(ContentModel.PROP_FIRSTNAME, (Serializable)((Object)"Guest"));
            properties.put(ContentModel.PROP_LASTNAME, (Serializable)((Object)""));
            properties.put(ContentModel.PROP_EMAIL, (Serializable)((Object)""));
            properties.put(ContentModel.PROP_ORGID, (Serializable)((Object)""));
            this.personService.createPerson(properties);
        }
        NodeRef personRef = this.personService.getPerson(this.guestId);
        this.permissionService.setInheritParentPermissions(personRef, false);
        this.permissionService.setPermission(personRef, this.guestId, "Consumer", true);
    }

    private NodeRef addGuestHomeSpace(NodeRef storeRootNodeRef, Properties configuration, String companyHomeChildName, String guestHomeChildName, NodeRef companyHomeRef) {
        List<NodeRef> nodeRefs = this.searchService.selectNodes(companyHomeRef, guestHomeChildName, null, this.namespaceService, false);
        if (nodeRefs.size() == 0) {
            String guestHomeName = this.messageSource.getMessage(GUEST_HOME_NAME, null, I18NUtil.getLocale());
            if (guestHomeName == null || guestHomeName.length() == 0) {
                throw new PatchException("Bootstrap property 'spaces.guest_home.name' is not present");
            }
            String guestHomeDescription = this.messageSource.getMessage(GUEST_HOME_DESCRIPTION, null, I18NUtil.getLocale());
            if (guestHomeDescription == null || guestHomeDescription.length() == 0) {
                throw new PatchException("Bootstrap property 'spaces.guest_home.description' is not present");
            }
            HashMap<QName, Serializable> properties = new HashMap<QName, Serializable>();
            properties.put(ContentModel.PROP_NAME, (Serializable)((Object)guestHomeName));
            properties.put(ContentModel.PROP_TITLE, (Serializable)((Object)guestHomeName));
            properties.put(ContentModel.PROP_DESCRIPTION, (Serializable)((Object)guestHomeDescription));
            properties.put(ContentModel.PROP_ICON, (Serializable)((Object)"space-icon-default"));
            ChildAssociationRef childAssocRef = this.nodeService.createNode(companyHomeRef, ContentModel.ASSOC_CONTAINS, QName.createQName(guestHomeChildName, this.namespaceService), ContentModel.TYPE_FOLDER, properties);
            NodeRef nodeRef = childAssocRef.getChildRef();
            this.nodeService.addAspect(nodeRef, ContentModel.ASPECT_UIFACETS, null);
            this.setGuestHomePermissions(nodeRef);
            return nodeRef;
        }
        if (nodeRefs.size() == 1) {
            NodeRef nodeRef = nodeRefs.get(0);
            this.setGuestHomePermissions(nodeRef);
            return nodeRef;
        }
        throw new PatchException("XPath returned too many results: \n   root: " + storeRootNodeRef + "\n" + "   xpath: " + companyHomeChildName + "\n" + "   results: " + nodeRefs);
    }

    private void setGuestHomePermissions(NodeRef nodeRef) {
        this.permissionService.setInheritParentPermissions(nodeRef, false);
        this.permissionService.setPermission(nodeRef, "GROUP_EVERYONE", "Consumer", true);
        this.permissionService.setPermission(nodeRef, this.guestId, "Consumer", true);
    }

    private NodeRef setCompanyHomeSpacePermissions(NodeRef storeRootNodeRef, String companyHomeChildName) {
        List<NodeRef> nodeRefs = this.searchService.selectNodes(storeRootNodeRef, companyHomeChildName, null, this.namespaceService, false);
        if (nodeRefs.size() == 0) {
            throw new PatchException("XPath didn't return any results: \n   root: " + storeRootNodeRef + "\n" + "   xpath: " + companyHomeChildName);
        }
        if (nodeRefs.size() > 1) {
            throw new PatchException("XPath returned too many results: \n   root: " + storeRootNodeRef + "\n" + "   xpath: " + companyHomeChildName + "\n" + "   results: " + nodeRefs);
        }
        NodeRef companyHomeRef = nodeRefs.get(0);
        this.permissionService.setInheritParentPermissions(companyHomeRef, false);
        this.permissionService.setPermission(companyHomeRef, "GROUP_EVERYONE", "Consumer", true);
        return companyHomeRef;
    }
}

