/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.admin.patch.impl;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import org.alfresco.i18n.I18NUtil;
import org.alfresco.repo.admin.patch.AbstractPatch;
import org.alfresco.repo.domain.Node;
import org.alfresco.repo.domain.PropertyValue;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.namespace.QName;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;

public class NodePropertySerializablePatch
extends AbstractPatch {
    private static final String MSG_SUCCESS = "patch.fixNodeSerializableValues.result";
    private HibernateHelper helper = new HibernateHelper();

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.helper.setSessionFactory(sessionFactory);
    }

    protected String applyInternal() throws Exception {
        int updatedEntries = this.helper.fixSerializableProperties();
        String msg = I18NUtil.getMessage((String)MSG_SUCCESS, (Object[])new Object[]{updatedEntries});
        return msg;
    }

    private static class HibernateHelper
    extends HibernateDaoSupport {
        private static final String QUERY_GET_NODES = "node.patch.GetNodesWithPersistedSerializableProperties";

        private HibernateHelper() {
        }

        public int fixSerializableProperties() {
            HibernateCallback callback = new HibernateCallback(){

                public Object doInHibernate(Session session) {
                    Query query = session.getNamedQuery(HibernateHelper.QUERY_GET_NODES);
                    Iterator iterator = query.iterate();
                    int count = 0;
                    while (iterator.hasNext()) {
                        Node node = (Node)iterator.next();
                        Map<QName, PropertyValue> properties = node.getProperties();
                        for (Map.Entry<QName, PropertyValue> entry : properties.entrySet()) {
                            PropertyValue propertyValue = entry.getValue();
                            if (propertyValue.getSerializableValue() == null || propertyValue.isMultiValued() || !"SERIALIZABLE".equals(propertyValue.getActualType())) continue;
                            Serializable value = propertyValue.getSerializableValue();
                            PropertyValue newPropertyValue = new PropertyValue(DataTypeDefinition.ANY, value);
                            entry.setValue(newPropertyValue);
                            ++count;
                        }
                    }
                    return new Integer(count);
                }
            };
            Integer updateCount = (Integer)this.getHibernateTemplate().execute(callback);
            return updateCount;
        }
    }
}

