/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.admin.patch.impl;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.alfresco.i18n.I18NUtil;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.admin.patch.AbstractPatch;
import org.alfresco.repo.importer.ImporterBootstrap;
import org.alfresco.service.cmr.admin.PatchException;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.namespace.QName;
import org.springframework.context.MessageSource;

public class SavedSearchFolderPatch
extends AbstractPatch {
    private static final String MSG_EXISTS = "patch.savedSearchesFolder.result.exists";
    private static final String MSG_CREATED = "patch.savedSearchesFolder.result.created";
    public static final String PROPERTY_COMPANY_HOME_CHILDNAME = "spaces.company_home.childname";
    public static final String PROPERTY_DICTIONARY_CHILDNAME = "spaces.dictionary.childname";
    public static final String PROPERTY_SAVED_SEARCHES_FOLDER_CHILDNAME = "spaces.savedsearches.childname";
    private static final String PROPERTY_SAVED_SEARCHES_FOLDER_NAME = "spaces.savedsearches.name";
    private static final String PROPERTY_SAVED_SEARCHES_FOLDER_DESCRIPTION = "spaces.savedsearches.description";
    private static final String PROPERTY_ICON = "space-icon-default";
    private ImporterBootstrap importerBootstrap;
    private MessageSource messageSource;
    protected NodeRef dictionaryNodeRef;
    protected Properties configuration;
    protected NodeRef savedSearchesFolderNodeRef;

    public void setImporterBootstrap(ImporterBootstrap importerBootstrap) {
        this.importerBootstrap = importerBootstrap;
    }

    public void setMessageSource(MessageSource messageSource) {
        this.messageSource = messageSource;
    }

    protected void checkCommonProperties() throws Exception {
        if (this.importerBootstrap == null) {
            throw new PatchException("'importerBootstrap' property has not been set");
        }
        if (this.namespaceService == null) {
            throw new PatchException("'namespaceService' property has not been set");
        }
        if (this.searchService == null) {
            throw new PatchException("'searchService' property has not been set");
        }
        if (this.nodeService == null) {
            throw new PatchException("'nodeService' property has not been set");
        }
    }

    protected void setUp() throws Exception {
        StoreRef storeRef = this.importerBootstrap.getStoreRef();
        if (storeRef == null) {
            throw new PatchException("Bootstrap store has not been set");
        }
        NodeRef storeRootNodeRef = this.nodeService.getRootNode(storeRef);
        this.configuration = this.importerBootstrap.getConfiguration();
        String companyHomeChildName = this.configuration.getProperty(PROPERTY_COMPANY_HOME_CHILDNAME);
        if (companyHomeChildName == null || companyHomeChildName.length() == 0) {
            throw new PatchException("Bootstrap property 'spaces.company_home.childname' is not present");
        }
        String dictionaryChildName = this.configuration.getProperty(PROPERTY_DICTIONARY_CHILDNAME);
        if (dictionaryChildName == null || dictionaryChildName.length() == 0) {
            throw new PatchException("Bootstrap property 'spaces.dictionary.childname' is not present");
        }
        String savedSearchesChildName = this.configuration.getProperty(PROPERTY_SAVED_SEARCHES_FOLDER_CHILDNAME);
        if (savedSearchesChildName == null || savedSearchesChildName.length() == 0) {
            throw new PatchException("Bootstrap property 'spaces.savedsearches.childname' is not present");
        }
        StringBuilder sb = new StringBuilder(512);
        sb.append("/").append(companyHomeChildName).append("/").append(dictionaryChildName);
        String xpath = sb.toString();
        List<NodeRef> nodeRefs = this.searchService.selectNodes(storeRootNodeRef, xpath, null, this.namespaceService, false);
        if (nodeRefs.size() == 0) {
            throw new PatchException("XPath didn't return any results: \n   root: " + storeRootNodeRef + "\n" + "   xpath: " + xpath);
        }
        if (nodeRefs.size() > 1) {
            throw new PatchException("XPath returned too many results: \n   root: " + storeRootNodeRef + "\n" + "   xpath: " + xpath + "\n" + "   results: " + nodeRefs);
        }
        this.dictionaryNodeRef = nodeRefs.get(0);
        xpath = savedSearchesChildName;
        nodeRefs = this.searchService.selectNodes(this.dictionaryNodeRef, xpath, null, this.namespaceService, false);
        if (nodeRefs.size() > 1) {
            throw new PatchException("XPath returned too many results: \n   dictionary node: " + this.dictionaryNodeRef + "\n" + "   xpath: " + xpath + "\n" + "   results: " + nodeRefs);
        }
        this.savedSearchesFolderNodeRef = nodeRefs.size() == 0 ? null : nodeRefs.get(0);
    }

    protected String applyInternal() throws Exception {
        this.checkCommonProperties();
        if (this.messageSource == null) {
            throw new PatchException("'messageSource' property has not been set");
        }
        this.setUp();
        String msg = null;
        if (this.savedSearchesFolderNodeRef == null) {
            this.createFolder();
            msg = I18NUtil.getMessage((String)MSG_CREATED, (Object[])new Object[]{this.savedSearchesFolderNodeRef});
        } else {
            msg = I18NUtil.getMessage((String)MSG_EXISTS, (Object[])new Object[]{this.savedSearchesFolderNodeRef});
        }
        return msg;
    }

    private void createFolder() {
        String savedSearchesChildName = this.configuration.getProperty(PROPERTY_SAVED_SEARCHES_FOLDER_CHILDNAME);
        if (savedSearchesChildName == null) {
            throw new PatchException("Bootstrap property 'spaces.savedsearches.childname' is not present");
        }
        String savedSearchesName = this.messageSource.getMessage(PROPERTY_SAVED_SEARCHES_FOLDER_NAME, null, I18NUtil.getLocale());
        if (savedSearchesName == null || savedSearchesName.length() == 0) {
            throw new PatchException("Bootstrap property 'spaces.savedsearches.name' is not present");
        }
        String savedSearchesDescription = this.messageSource.getMessage(PROPERTY_SAVED_SEARCHES_FOLDER_DESCRIPTION, null, I18NUtil.getLocale());
        if (savedSearchesDescription == null || savedSearchesDescription.length() == 0) {
            throw new PatchException("Bootstrap property 'spaces.savedsearches.description' is not present");
        }
        HashMap<QName, Serializable> properties = new HashMap<QName, Serializable>(7);
        properties.put(ContentModel.PROP_NAME, (Serializable)((Object)savedSearchesName));
        properties.put(ContentModel.PROP_TITLE, (Serializable)((Object)savedSearchesName));
        properties.put(ContentModel.PROP_DESCRIPTION, (Serializable)((Object)savedSearchesDescription));
        properties.put(ContentModel.PROP_ICON, (Serializable)((Object)PROPERTY_ICON));
        ChildAssociationRef childAssocRef = this.nodeService.createNode(this.dictionaryNodeRef, ContentModel.ASSOC_CONTAINS, QName.resolveToQName(this.namespaceService, savedSearchesChildName), ContentModel.TYPE_FOLDER, properties);
        this.savedSearchesFolderNodeRef = childAssocRef.getChildRef();
        this.nodeService.addAspect(this.savedSearchesFolderNodeRef, ContentModel.ASPECT_UIFACETS, null);
    }
}

