/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.admin.patch.impl;

import org.alfresco.i18n.I18NUtil;
import org.alfresco.repo.admin.patch.impl.SavedSearchFolderPatch;
import org.alfresco.service.cmr.admin.PatchException;
import org.alfresco.service.cmr.security.PermissionService;

public class SavedSearchPermissionPatch
extends SavedSearchFolderPatch {
    private static final String MSG_CREATED = "patch.savedSearchesPermission.result.applied";
    private static final String ERR_NOT_FOUND = "patch.savedSearchesPermission.err.not_found";
    private PermissionService permissionService;

    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }

    protected String applyInternal() throws Exception {
        this.checkCommonProperties();
        if (this.permissionService == null) {
            throw new PatchException("'permissionService' property has not been set");
        }
        this.setUp();
        if (this.savedSearchesFolderNodeRef == null) {
            String msg = I18NUtil.getMessage((String)ERR_NOT_FOUND);
            throw new PatchException(msg);
        }
        this.permissionService.setPermission(this.savedSearchesFolderNodeRef, "GROUP_EVERYONE", "Contributor", true);
        String msg = I18NUtil.getMessage((String)MSG_CREATED, (Object[])new Object[]{this.savedSearchesFolderNodeRef});
        return msg;
    }
}

