/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.admin.patch.impl;

import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.alfresco.i18n.I18NUtil;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.admin.patch.AbstractPatch;
import org.alfresco.repo.importer.ACPImportPackageHandler;
import org.alfresco.repo.importer.ImporterBootstrap;
import org.alfresco.service.cmr.admin.PatchException;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.view.ImporterService;
import org.alfresco.service.cmr.view.Location;
import org.alfresco.service.namespace.QName;
import org.springframework.context.MessageSource;
import org.springframework.core.io.ClassPathResource;

public class ScriptsFolderPatch
extends AbstractPatch {
    private static final String MSG_EXISTS = "patch.scriptsFolder.result.exists";
    private static final String MSG_CREATED = "patch.scriptsFolder.result.created";
    public static final String PROPERTY_COMPANY_HOME_CHILDNAME = "spaces.company_home.childname";
    public static final String PROPERTY_DICTIONARY_CHILDNAME = "spaces.dictionary.childname";
    public static final String PROPERTY_SCRIPTS_FOLDER_CHILDNAME = "spaces.scripts.childname";
    private static final String PROPERTY_SCRIPTS_FOLDER_NAME = "spaces.scripts.name";
    private static final String PROPERTY_SCRIPTS_FOLDER_DESCRIPTION = "spaces.scripts.description";
    private static final String PROPERTY_ICON = "space-icon-default";
    private ImporterBootstrap importerBootstrap;
    private ImporterService importerService;
    private MessageSource messageSource;
    protected NodeRef dictionaryNodeRef;
    protected Properties configuration;
    protected NodeRef scriptsFolderNodeRef;
    private String scriptsACP;

    public void setImporterBootstrap(ImporterBootstrap importerBootstrap) {
        this.importerBootstrap = importerBootstrap;
    }

    public void setImporterService(ImporterService importerService) {
        this.importerService = importerService;
    }

    public void setMessageSource(MessageSource messageSource) {
        this.messageSource = messageSource;
    }

    public void setScriptsACP(String scriptsACP) {
        this.scriptsACP = scriptsACP;
    }

    protected void checkCommonProperties() throws Exception {
        this.checkPropertyNotNull(this.importerBootstrap, "importerBootstrap");
        this.checkPropertyNotNull(this.importerService, "importerService");
        this.checkPropertyNotNull(this.messageSource, "messageSource");
        if (this.namespaceService == null) {
            throw new PatchException("'namespaceService' property has not been set");
        }
        if (this.searchService == null) {
            throw new PatchException("'searchService' property has not been set");
        }
        if (this.nodeService == null) {
            throw new PatchException("'nodeService' property has not been set");
        }
        this.checkPropertyNotNull(this.scriptsACP, "scriptsACP");
    }

    protected void setUp() throws Exception {
        StoreRef storeRef = this.importerBootstrap.getStoreRef();
        if (storeRef == null) {
            throw new PatchException("Bootstrap store has not been set");
        }
        NodeRef storeRootNodeRef = this.nodeService.getRootNode(storeRef);
        this.configuration = this.importerBootstrap.getConfiguration();
        String companyHomeChildName = this.configuration.getProperty(PROPERTY_COMPANY_HOME_CHILDNAME);
        if (companyHomeChildName == null || companyHomeChildName.length() == 0) {
            throw new PatchException("Bootstrap property 'spaces.company_home.childname' is not present");
        }
        String dictionaryChildName = this.configuration.getProperty(PROPERTY_DICTIONARY_CHILDNAME);
        if (dictionaryChildName == null || dictionaryChildName.length() == 0) {
            throw new PatchException("Bootstrap property 'spaces.dictionary.childname' is not present");
        }
        String scriptsChildName = this.configuration.getProperty(PROPERTY_SCRIPTS_FOLDER_CHILDNAME);
        if (scriptsChildName == null || scriptsChildName.length() == 0) {
            throw new PatchException("Bootstrap property 'spaces.scripts.childname' is not present");
        }
        StringBuilder sb = new StringBuilder(256);
        sb.append("/").append(companyHomeChildName).append("/").append(dictionaryChildName);
        String xpath = sb.toString();
        List<NodeRef> nodeRefs = this.searchService.selectNodes(storeRootNodeRef, xpath, null, this.namespaceService, false);
        if (nodeRefs.size() == 0) {
            throw new PatchException("XPath didn't return any results: \n   root: " + storeRootNodeRef + "\n" + "   xpath: " + xpath);
        }
        if (nodeRefs.size() > 1) {
            throw new PatchException("XPath returned too many results: \n   root: " + storeRootNodeRef + "\n" + "   xpath: " + xpath + "\n" + "   results: " + nodeRefs);
        }
        this.dictionaryNodeRef = nodeRefs.get(0);
        xpath = scriptsChildName;
        nodeRefs = this.searchService.selectNodes(this.dictionaryNodeRef, xpath, null, this.namespaceService, false);
        if (nodeRefs.size() > 1) {
            throw new PatchException("XPath returned too many results: \n   dictionary node: " + this.dictionaryNodeRef + "\n" + "   xpath: " + xpath + "\n" + "   results: " + nodeRefs);
        }
        this.scriptsFolderNodeRef = nodeRefs.size() == 0 ? null : nodeRefs.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String applyInternal() throws Exception {
        this.checkCommonProperties();
        if (this.messageSource == null) {
            throw new PatchException("'messageSource' property has not been set");
        }
        this.setUp();
        String msg = null;
        if (this.scriptsFolderNodeRef == null) {
            this.createFolder();
            try {
                this.authenticationComponent.setCurrentUser(this.authenticationComponent.getSystemUserName());
                this.importContent();
            }
            finally {
                this.authenticationComponent.clearCurrentSecurityContext();
            }
            msg = I18NUtil.getMessage((String)MSG_CREATED, (Object[])new Object[]{this.scriptsFolderNodeRef});
        } else {
            msg = I18NUtil.getMessage((String)MSG_EXISTS, (Object[])new Object[]{this.scriptsFolderNodeRef});
        }
        return msg;
    }

    private void createFolder() {
        String savedSearchesChildName = this.configuration.getProperty(PROPERTY_SCRIPTS_FOLDER_CHILDNAME);
        if (savedSearchesChildName == null) {
            throw new PatchException("Bootstrap property 'spaces.scripts.childname' is not present");
        }
        String savedSearchesName = this.messageSource.getMessage(PROPERTY_SCRIPTS_FOLDER_NAME, null, I18NUtil.getLocale());
        if (savedSearchesName == null || savedSearchesName.length() == 0) {
            throw new PatchException("Bootstrap property 'spaces.scripts.name' is not present");
        }
        String savedSearchesDescription = this.messageSource.getMessage(PROPERTY_SCRIPTS_FOLDER_DESCRIPTION, null, I18NUtil.getLocale());
        if (savedSearchesDescription == null || savedSearchesDescription.length() == 0) {
            throw new PatchException("Bootstrap property 'spaces.scripts.description' is not present");
        }
        HashMap<QName, Serializable> properties = new HashMap<QName, Serializable>(7);
        properties.put(ContentModel.PROP_NAME, (Serializable)((Object)savedSearchesName));
        properties.put(ContentModel.PROP_TITLE, (Serializable)((Object)savedSearchesName));
        properties.put(ContentModel.PROP_DESCRIPTION, (Serializable)((Object)savedSearchesDescription));
        properties.put(ContentModel.PROP_ICON, (Serializable)((Object)PROPERTY_ICON));
        ChildAssociationRef childAssocRef = this.nodeService.createNode(this.dictionaryNodeRef, ContentModel.ASSOC_CONTAINS, QName.resolveToQName(this.namespaceService, savedSearchesChildName), ContentModel.TYPE_FOLDER, properties);
        this.scriptsFolderNodeRef = childAssocRef.getChildRef();
        this.nodeService.addAspect(this.scriptsFolderNodeRef, ContentModel.ASPECT_UIFACETS, null);
    }

    private void importContent() throws IOException {
        ClassPathResource acpResource = new ClassPathResource(this.scriptsACP);
        ACPImportPackageHandler acpHandler = new ACPImportPackageHandler(acpResource.getFile(), null);
        Location importLocation = new Location(this.scriptsFolderNodeRef);
        this.importerService.importView(acpHandler, importLocation, null, null);
    }
}

